/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util;

import java.util.HashSet;
import java.util.Set;

public class JaketConfigurationUtils {
    private static String[] includedInterfacePackages;
    private static final String[] includedTypePackages;
    private static final Set<String> CLOSED_TYPES;

    public static boolean isExcludedInterface(Class<?> clazz) {
        if (includedInterfacePackages == null || includedInterfacePackages.length == 0) {
            return false;
        }
        for (String packagePrefix : includedInterfacePackages) {
            if (!clazz.getCanonicalName().startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExcludedType(Class<?> clazz) {
        for (String packagePrefix : includedTypePackages) {
            if (!clazz.getCanonicalName().startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean needAnalyzing(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        if (CLOSED_TYPES.contains(canonicalName)) {
            return false;
        }
        return !JaketConfigurationUtils.isExcludedType(clazz);
    }

    static {
        includedTypePackages = new String[]{"org.springframework"};
        CLOSED_TYPES = new HashSet<String>();
        CLOSED_TYPES.add("java.lang.String");
        CLOSED_TYPES.add("java.util.Date");
    }
}

