/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.JsonMarshaler;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.Baggage;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class DebugUtil {
    public static String getMseDebugValueByTrace(Baggage baggage) {
        JsonMarshaler jsonMarshaler;
        Map transHeaders;
        List headerValList;
        if (baggage == null) {
            return null;
        }
        String transHeaderStr = baggage.getEntryValue("_mshd_");
        if (!StringUtils.isEmpty(transHeaderStr) && (headerValList = (List)(transHeaders = (jsonMarshaler = GlobalInstanceHolder.getInstance(JsonMarshaler.class)).parseObject(transHeaderStr, Map.class)).get("x-mse-debug")) != null && headerValList.size() > 0) {
            return (String)headerValList.get(0);
        }
        return null;
    }

    public static void logWarnWhenMseDebugOpen(String mseDebugValue, PatchLogger logger, String type, String message) {
        if (MicroServiceConfig.isMseRouterDebugEnable() || !StringUtils.isEmpty(mseDebugValue)) {
            logger.warning("[" + type + "] " + "x-mse-debug" + ": " + mseDebugValue + ",message: [" + message + "]");
            if ("Router".equals(type)) {
                // empty if block
            }
        } else {
            logger.log(Level.FINE, message);
        }
    }
}

