/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.traffic;

import com.alibaba.csp.mse.sentinel.traffic.core.LocalityRouter;
import com.alibaba.csp.mse.sentinel.traffic.core.TrafficRouter;
import com.alibaba.csp.mse.sentinel.traffic.env.EnvUtils;
import com.alibaba.csp.mse.sentinel.traffic.model.CanaryMatchResult;
import com.alibaba.csp.mse.sentinel.traffic.model.Instance;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.BaggageUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceCommonUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.canary.Tag;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.traffic.MseTrafficContextMatch;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.CollectionUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.JSON;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.ObjectUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MseTrafficRouter {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(MseTrafficContextMatch.class.getName());
    private static TrafficRouter TRAFFIC_INSTANCE = new TrafficRouter();
    private static LocalityRouter LOCALITY_INSTANCE = new LocalityRouter();
    private static volatile String zoneId = null;

    public static List<Instance> route(String serviceId, List<Instance> instanceList) {
        String appId = MseTrafficRouter.getAppId(instanceList);
        Set<String> envsInRouterRule = MseTrafficRouter.calculateEnvsInRouterRule();
        String trafficTag = MseTrafficRouter.calculateTrafficTag(serviceId, appId);
        List instancesAfterTrafficRoute = TRAFFIC_INSTANCE.route(trafficTag, envsInRouterRule, instanceList);
        String zone = MicroServiceCommonUtil.getZoneId();
        return LOCALITY_INSTANCE.route(zone, instancesAfterTrafficRoute);
    }

    private static String getAppId(List<Instance> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return null;
        }
        for (Instance instance : instances) {
            String appId = instance.getAppId();
            if (!StringUtils.isNotEmpty(appId)) continue;
            return appId;
        }
        return null;
    }

    public static Set<String> calculateEnvsInRouterRule() {
        HashSet<String> envsInRouterRule = new HashSet<String>();
        Map<String, BaggageEntry> baggageItems = Baggage.fromContext(Context.current()).asMap();
        if (baggageItems != null && baggageItems.get("__microservice_match_result__") != null) {
            List<CanaryMatchResult> resultList = JSON.parseArray(baggageItems.get("__microservice_match_result__").getValue(), CanaryMatchResult.class);
            for (CanaryMatchResult matchResult : resultList) {
                envsInRouterRule.addAll(matchResult.getTag());
            }
            logger.info("[MseTrafficRouter]get CanaryMatchResult: {}", (Object)resultList);
        }
        return envsInRouterRule;
    }

    public static String calculateTrafficTag(String serviceId, String appId) {
        String tmp;
        String trafficTag = null;
        if (MicroServiceCommonUtil.isMseProVersion() && MicroServiceConfig.isMseTagTraceEnable() && StringUtils.isNotEmpty(tmp = EnvUtils.getLocalEnv())) {
            trafficTag = tmp;
        }
        Map<Object, Object> baggageItems = null;
        String traceId = null;
        if (Span.fromContext(Context.current()).getSpanContext().getTraceId() != null) {
            traceId = Span.fromContext(Context.current()).getSpanContext().getTraceId();
            baggageItems = Baggage.fromContext(Context.current()).asMap();
        }
        if (baggageItems == null) {
            baggageItems = new HashMap();
        }
        BaggageEntry matchResultTags = (BaggageEntry)baggageItems.get("__microservice_tag__");
        if (StringUtils.isEmpty(trafficTag) && matchResultTags != null && StringUtils.isNotEmpty(matchResultTags.getValue())) {
            List<Tag> tmpTagList = JSON.parseArray(matchResultTags.getValue(), Tag.class);
            Tag finalTag = null;
            int maxPriority = Integer.MIN_VALUE;
            for (Tag tag : tmpTagList) {
                if (tag.getPriority() <= maxPriority) continue;
                finalTag = tag;
            }
            if (finalTag != null) {
                trafficTag = finalTag.getName();
            }
        }
        if (StringUtils.isNotEmpty(trafficTag) && (matchResultTags == null || StringUtils.isEmpty(matchResultTags.getValue()))) {
            List<Tag> tagList = Collections.singletonList(new Tag(trafficTag, 1));
            String tagListStr = JSON.toJSONString(tagList);
            logger.debug("[MseTrafficRouter]put {}:{} to baggageItems.", (Object)"__microservice_tag__", (Object)tagListStr);
            boolean result = BaggageUtil.putBaggageDirectly("__microservice_tag__", tagListStr);
            if (!result) {
                logger.warn("[MseTrafficRouter]put {}:{} to baggageItems failed.", (Object)"__microservice_tag__", (Object)tagListStr);
            }
        }
        BaggageEntry matchResultBaggageEntry = (BaggageEntry)baggageItems.get("__microservice_match_result__");
        String matchResultStr = null;
        if (matchResultBaggageEntry != null) {
            matchResultStr = matchResultBaggageEntry.getValue();
        }
        if (StringUtils.isEmpty(trafficTag) && StringUtils.isNotEmpty(matchResultStr)) {
            List<CanaryMatchResult> tmpMatchResultList = JSON.parseArray(matchResultStr, CanaryMatchResult.class);
            CanaryMatchResult finalMatchResult = null;
            int maxPriority = Integer.MIN_VALUE;
            for (CanaryMatchResult matchResult : tmpMatchResultList) {
                if (!StringUtils.equals(matchResult.getAppId(), appId) || matchResult.getPriority() <= maxPriority || !ObjectUtils.equals(matchResult.getMatched(), true)) continue;
                finalMatchResult = matchResult;
            }
            List tags = null;
            if (finalMatchResult != null) {
                tags = finalMatchResult.getTag();
            }
            if (CollectionUtils.isNotEmpty(tags) && StringUtils.isNotEmpty((String)tags.get(0))) {
                trafficTag = (String)tags.get(0);
                if (StringUtils.isNotEmpty(trafficTag) && ObjectUtils.equals(finalMatchResult.getCarryData(), true)) {
                    logger.info("[netflix.loadbalancer][canary]" + traceId + " put baggageItems " + "__microservice_tag__" + ":" + trafficTag);
                    BaggageUtil.putBaggageDirectly("__microservice_tag__", JSON.toJSONString(Collections.singletonList(new Tag(trafficTag, finalMatchResult.getPriority()))));
                }
                logger.info("[netflix.loadbalancer/canary]" + traceId + " call " + serviceId + " get traffic tag from traffic " + "__microservice_match_result__" + "-" + (String)tags.get(0));
            }
        }
        return trafficTag == null ? "_base" : trafficTag;
    }
}

