/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.traffic;

import com.alibaba.csp.mse.sentinel.traffic.config.Tag;
import com.alibaba.csp.mse.sentinel.traffic.core.TrafficContextMatch;
import com.alibaba.csp.mse.sentinel.traffic.model.CanaryMatchResult;
import com.alibaba.csp.mse.sentinel.traffic.model.TrafficContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AliyunContextHolderUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.BaggageUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.CollectionUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.JSON;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.List;

public class MseTrafficContextMatch {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(MseTrafficContextMatch.class.getName());
    private static TrafficContextMatch INSTANCE = new TrafficContextMatch();

    public static TrafficContextMatch getInstance() {
        return INSTANCE;
    }

    public static List<CanaryMatchResult> trafficContextToMatchResult(TrafficContext context) {
        if (context == null) {
            return Collections.emptyList();
        }
        logger.debug("[TrafficContextMatch] trafficContextToMatchResult before, context:{}", (Object)context);
        List resultList = INSTANCE.trafficContextToMatchResult(context);
        logger.debug("[TrafficContextMatch] trafficContextToMatchResult after, resultList:{}", (Object)resultList);
        if (CollectionUtils.isNotEmpty(resultList)) {
            String resultListStr = JSON.toJSONString(resultList);
            logger.debug("[TrafficContextMatch]put {}:{} to baggageItems.", (Object)"__microservice_match_result__", (Object)resultListStr);
            boolean result = BaggageUtil.putBaggageDirectly("__microservice_match_result__", resultListStr);
            if (!result) {
                logger.error("[TrafficContextMatch]put {}:{} to baggageItems failed.", (Object)"__microservice_match_result__", (Object)resultListStr);
            }
        }
        return resultList;
    }

    public static List<Tag> trafficContextToMatchTag(TrafficContext context) {
        Boolean rateMatched = (Boolean)AliyunContextHolderUtils.getFromAliyunContext("__microservice_rate_matched__", Context.current());
        if (rateMatched == null) {
            rateMatched = false;
        }
        context.setRateMatched(rateMatched.booleanValue());
        logger.debug("[TrafficContextMatch] trafficContextToMatchTag before, context:{}", (Object)context);
        List tagList = INSTANCE.trafficContextToMatchTag(context);
        logger.debug("[TrafficContextMatch] trafficContextToMatchTag after, tagList:{}", (Object)tagList);
        if (CollectionUtils.isNotEmpty(tagList)) {
            String tagListStr = JSON.toJSONString(tagList);
            logger.debug("[TrafficContextMatch]put {}:{} to baggageItems.", (Object)"__microservice_tag__", (Object)tagListStr);
            boolean result = BaggageUtil.putBaggageDirectly("__microservice_tag__", tagListStr);
            if (!result) {
                logger.error("[TrafficContextMatch]put {}:{} to baggageItems failed.", (Object)"__microservice_tag__", (Object)tagListStr);
            }
        }
        AliyunContextHolderUtils.putToAliyunContext("__microservice_rate_matched__", context.isRateMatched(), Context.current());
        return tagList;
    }
}

