/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder;

import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinitionBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.ClassUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.JaketConfigurationUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DefaultTypeBuilder {
    public static TypeDefinition build(Class<?> clazz, TypeDefinitionBuilder typeDefinitionBuilder, Map<String, TypeDefinition> typeCache) {
        String canonicalName = clazz.getCanonicalName();
        if (typeCache.containsKey(canonicalName)) {
            return typeCache.get(canonicalName);
        }
        TypeDefinition td = new TypeDefinition(canonicalName);
        typeCache.put(canonicalName, td);
        if (!JaketConfigurationUtils.needAnalyzing(clazz)) {
            return td;
        }
        List<Field> fields = ClassUtils.getNonStaticFields(clazz);
        ArrayList<String> definitions = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (Field field : fields) {
            String fieldName = field.getName();
            Class<?> fieldClass = field.getType();
            Type fieldType = field.getGenericType();
            TypeDefinition fieldTd = TypeDefinitionBuilder.build(fieldType, fieldClass, typeDefinitionBuilder, typeCache);
            definitions.add(fieldTd.getType());
            names.add(fieldClass.getName());
            td.getProperties().put(fieldName, fieldTd.getType());
        }
        td.setItems(definitions);
        typeDefinitionBuilder.getTypeDiffList().add(td);
        return td;
    }

    private DefaultTypeBuilder() {
    }
}

