/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder;

import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinitionBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.TypeBuilder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class CollectionTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Type type, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Collection.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, TypeDefinitionBuilder typeDefinitionBuilder, Map<String, TypeDefinition> typeCache) {
        TypeDefinition td = null;
        if (!(type instanceof ParameterizedType)) {
            td = new TypeDefinition(clazz.getCanonicalName());
            typeCache.put(td.getType(), td);
            return td;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Object[] actualTypeArgs = parameterizedType.getActualTypeArguments();
        if (actualTypeArgs == null || actualTypeArgs.length != 1) {
            throw new IllegalArgumentException(MessageFormat.format("[ServiceDefinitionBuilder] Collection type [{0}] with unexpected amount of arguments [{1}]." + Arrays.toString(actualTypeArgs), type, actualTypeArgs));
        }
        String canonicalName = parameterizedType.toString();
        if (typeCache.containsKey(canonicalName)) {
            return typeCache.get(canonicalName);
        }
        td = new TypeDefinition(canonicalName);
        typeCache.put(canonicalName, td);
        ArrayList<String> tdList = new ArrayList<String>();
        Object actualType = actualTypeArgs[0];
        if (actualType instanceof ParameterizedType) {
            Class rawType = (Class)((ParameterizedType)actualType).getRawType();
            TypeDefinition itemTypeDefinition = TypeDefinitionBuilder.build((Type)actualType, rawType, typeDefinitionBuilder, typeCache);
            tdList.add(itemTypeDefinition.getType());
        } else if (actualType instanceof Class) {
            Class actualClass = (Class)actualType;
            TypeDefinition itemTypeDefinition = TypeDefinitionBuilder.build(null, actualClass, typeDefinitionBuilder, typeCache);
            tdList.add(itemTypeDefinition.getType());
        }
        td.setItems(tdList);
        return td;
    }
}

