/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder;

import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinitionBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.TypeBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public class ArrayTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Type type, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return clazz.isArray();
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, TypeDefinitionBuilder typeDefinitionBuilder, Map<String, TypeDefinition> typeCache) {
        Class<?> componentType = clazz.getComponentType();
        String canonicalName = clazz.getCanonicalName();
        if (typeCache.containsKey(canonicalName)) {
            return typeCache.get(canonicalName);
        }
        TypeDefinition td = new TypeDefinition(canonicalName);
        typeCache.put(canonicalName, td);
        ArrayList<String> tdList = new ArrayList<String>();
        TypeDefinition itemTypeDefinition = TypeDefinitionBuilder.build(componentType, componentType, typeDefinitionBuilder, typeCache);
        tdList.add(itemTypeDefinition.getType());
        td.setItems(tdList);
        return td;
    }
}

