/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.TypeDefinition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.ArrayTypeBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.CollectionTypeBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.DefaultTypeBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.EnumTypeBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.GenericTypeBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.MapTypeBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.metadata.builder.TypeBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class TypeDefinitionBuilder {
    private static final PatchLogger logger = PatchLogger.getLogger(TypeDefinitionBuilder.class.getName());
    private static final List<TypeBuilder> BUILDERS;
    private List<TypeDefinition> typeDiffList = new CopyOnWriteArrayList<TypeDefinition>();

    public List<TypeDefinition> getTypeDiffList() {
        return this.typeDiffList;
    }

    public void setTypeDiffList(List<TypeDefinition> typeDiffList) {
        this.typeDiffList = typeDiffList;
    }

    public static TypeDefinition build(Type type, Class<?> clazz, TypeDefinitionBuilder typeDefinitionBuilder, Map<String, TypeDefinition> types) {
        TypeBuilder builder = TypeDefinitionBuilder.getGenericTypeBuilder(type, clazz);
        TypeDefinition td = builder != null ? builder.build(type, clazz, typeDefinitionBuilder, types) : DefaultTypeBuilder.build(clazz, typeDefinitionBuilder, types);
        return td;
    }

    private static TypeBuilder getGenericTypeBuilder(Type type, Class<?> clazz) {
        for (TypeBuilder builder : BUILDERS) {
            try {
                if (!builder.accept(type, clazz)) continue;
                return builder;
            }
            catch (NoClassDefFoundError cnfe) {
                logger.info("Throw classNotFound (" + cnfe.getMessage() + ") in " + builder.getClass());
            }
        }
        return null;
    }

    public TypeDefinition build(Type type, Class<?> clazz, Map<String, TypeDefinition> types) {
        return TypeDefinitionBuilder.build(type, clazz, this, types);
    }

    static {
        ArrayList<TypeBuilder> builders = new ArrayList<TypeBuilder>();
        builders.add(new ArrayTypeBuilder());
        builders.add(new CollectionTypeBuilder());
        builders.add(new MapTypeBuilder());
        builders.add(new EnumTypeBuilder());
        builders.add(new GenericTypeBuilder());
        BUILDERS = builders;
    }
}

