/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.spring;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.AgentRegisterStatusEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.StartupContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.ReadinessCondition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.spring.SpringLaunchRecorder;

public class SpringReadiness
extends ReadinessCondition {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(SpringReadiness.class.getName());
    private static Long appStartTime = null;

    public SpringReadiness(int order) {
        super(order);
    }

    @Override
    public String name() {
        return "SPRING_READINESS";
    }

    @Override
    public boolean ready() {
        long waitTime;
        if (SpringLaunchRecorder.detectSpring()) {
            return this.springReadiness();
        }
        if (appStartTime == null) {
            long agentStartTime = StartupContext.getStartTime();
            appStartTime = System.currentTimeMillis() - agentStartTime < 15000L ? agentStartTime : System.currentTimeMillis();
        }
        if ((waitTime = System.currentTimeMillis() - appStartTime) < MicroServiceConfig.SPRING_CONTEXT_REFRESH_WAIT_TIME) {
            logger.warn("[STARTUP_ONLINE][SPRING] waiting for spring context launch. remaining {}s", (Object)((MicroServiceConfig.SPRING_CONTEXT_REFRESH_WAIT_TIME - waitTime) / 1000L));
            return false;
        }
        logger.warn("[STARTUP_ONLINE][SPRING] no spring context detected in {}ms, skip checking spring.", (Object)MicroServiceConfig.SPRING_CONTEXT_REFRESH_WAIT_TIME);
        this.setStopCheck(true);
        return true;
    }

    public boolean springReadiness() {
        boolean springLaunchSuccess = SpringReadiness.doCheckSpringLaunchSuccess();
        if (springLaunchSuccess && AgentRegisterStatusEnum.ONLINE.equals((Object)StartupContext.hasRegistered)) {
            logger.warn("[STARTUP_ONLINE][SPRING] spring context check successfully finished and user app registering finished meanwhile. Never check spring again.");
            this.setStopCheck(true);
        }
        return springLaunchSuccess;
    }

    public static boolean doCheckSpringLaunchSuccess() {
        boolean hasRefreshed = SpringLaunchRecorder.hasRefreshed();
        if (!hasRefreshed) {
            return false;
        }
        boolean hasFailure = SpringLaunchRecorder.hasFailure();
        if (hasFailure) {
            return false;
        }
        long lastContextRefreshTime = SpringLaunchRecorder.getLastContextRefreshTimeOrNow();
        if (System.currentTimeMillis() - lastContextRefreshTime < 5000L) {
            logger.warn("[STARTUP_ONLINE][SPRING] spring context refreshing, wait for 5s, last context refresh time: {}", (Object)lastContextRefreshTime);
            return false;
        }
        logger.warn("[STARTUP_ONLINE][SPRING] spring launch success! spring check pass!");
        return true;
    }
}

