/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.ReadinessCondition;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.msegov.MseReadiness;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.spring.SpringLaunchRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.spring.SpringReadiness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReadinessChecker {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(SpringLaunchRecorder.class.getName());
    private static final List<ReadinessCondition> readinessConditions = new ArrayList<ReadinessCondition>();

    public static synchronized boolean ready() {
        long start = System.currentTimeMillis();
        for (ReadinessCondition condition : readinessConditions) {
            long before = System.currentTimeMillis();
            if (condition.shouldStopCheck()) continue;
            boolean pass = condition.ready();
            logger.warn("[STARTUP_ONLINE][{}] readiness check: {}, cost: {}ms", condition.name(), pass, System.currentTimeMillis() - before);
            if (pass) continue;
            return false;
        }
        logger.warn("[STARTUP_ONLINE] all readiness check passed, cost: {}ms", (Object)(System.currentTimeMillis() - start));
        return true;
    }

    public static synchronized void addReadinessCondition(ReadinessCondition readinessCondition) {
        readinessConditions.add(readinessCondition);
        Collections.sort(readinessConditions);
        logger.warn("[STARTUP_ONLINE] add readiness check condition: {}, order: {}", (Object)readinessCondition.name(), (Object)readinessCondition.order());
    }

    static {
        ReadinessChecker.addReadinessCondition(new SpringReadiness(60));
        ReadinessChecker.addReadinessCondition(new MseReadiness(100));
    }
}

