/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.AgentRegisterStatusEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless.readiness.ReadinessChecker;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.MicroServiceUtil;
import java.util.HashSet;
import java.util.Set;

public class StartupContext {
    private static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(StartupContext.class.getName());
    public static volatile int APP_TYPE = 0;
    public static volatile boolean hasOnline = false;
    public static volatile Long exportedTimestamp = null;
    private static volatile Long startTime = null;
    public static volatile AgentRegisterStatusEnum hasRegistered = AgentRegisterStatusEnum.UNKNOWN;
    private static volatile Boolean containsConditionRegister = null;
    private static volatile boolean losslessRegisterConditionPass = false;
    private static final Set<String> EXCLUDE_URLS = new HashSet<String>();

    public static void setStartTime(Long startTime) {
        StartupContext.startTime = startTime;
    }

    public static Long getStartTime() {
        if (startTime == null) {
            startTime = System.currentTimeMillis();
            LOGGER.warn("[BUG-DETECTED] StartupContext.startTime not set yet, please check MseTaskInitializer status");
        }
        return startTime;
    }

    public static void setExportedTimestamp(Long exportedTimestamp) {
        StartupContext.exportedTimestamp = exportedTimestamp;
    }

    public static void initAppType(ClassLoader classLoader) {
        if (APP_TYPE != 0) {
            return;
        }
        try {
            Class.forName("org.springframework.cloud.gateway.config.GatewayAutoConfiguration", false, classLoader);
            LOGGER.warn("[STARTUP_ONLINE] is SCG JAVA gateway: true");
            APP_TYPE = 2;
            return;
        }
        catch (Exception e) {
            LOGGER.warn("[STARTUP_ONLINE] is SCG JAVA gateway: false");
            try {
                Class.forName("org.springframework.cloud.netflix.zuul.ZuulProxyMarkerConfiguration", false, classLoader);
                Class.forName("com.netflix.zuul.ZuulFilter", false, classLoader);
                LOGGER.warn("[STARTUP_ONLINE] is Zuul JAVA gateway: true");
                APP_TYPE = 2;
                return;
            }
            catch (Exception e2) {
                LOGGER.warn("[STARTUP_ONLINE] is Zuul JAVA gateway: false");
                APP_TYPE = 1;
                return;
            }
        }
    }

    public static boolean readiness() {
        return ReadinessChecker.ready();
    }

    public static Set<String> getExcludeUrls() {
        return EXCLUDE_URLS;
    }

    public static boolean isEurekaRegistrationApplication() {
        Object applicationInfoManager = MicroServiceUtil.EUREKA_MULTI_REGISTRY_MAP.get("applicationInfoManager");
        return applicationInfoManager != null;
    }

    public static boolean isLosslessRegisterConditionPass() {
        return losslessRegisterConditionPass;
    }

    public static void setLosslessRegisterConditionPass(boolean pass) {
        losslessRegisterConditionPass = pass;
    }

    public static synchronized boolean containsConditionRegister() {
        if (containsConditionRegister == null) {
            String httpConfig = System.getProperty("mse_lossless_register_condition_on_http_get", System.getenv("mse_lossless_register_condition_on_http_get"));
            String systemPropertyConfig = System.getProperty("mse_lossless_register_condition_on_system_property_true", System.getenv("mse_lossless_register_condition_on_system_property_true"));
            containsConditionRegister = httpConfig != null || systemPropertyConfig != null;
        }
        return containsConditionRegister;
    }

    static {
        EXCLUDE_URLS.add("/__mse__/readiness");
        EXCLUDE_URLS.add("/health");
        EXCLUDE_URLS.add("/readiness");
        EXCLUDE_URLS.add("/actuator/prometheus");
    }
}

