/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.AgentInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.HttpGet;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.MicroServiceUtil;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class SpringCloudActiveNoticeManager {
    private static final int NOTICE_CONNECT_TIMEOUT_MS = 500;
    private static final int NOTICE_READ_TIMEOUT_MS = 500;
    private static final String K8S_PRE_STOP_SLEEP_TIME_CONFIG_KEY = "profiler.micro.service.pre.stop.wait.time";
    private static final int ACTIVE_NOTICE_TIMEOUT_SECONDS = SpringCloudActiveNoticeManager.calculateActiveNoticeTimeoutSeconds();
    public static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(SpringCloudActiveNoticeManager.class.getName());
    public static ConcurrentHashMap<String, Long> remoteIpList = new ConcurrentHashMap();

    public static void addRemoteIp(String remoteIp) {
        if (!MicroServiceConfig.isSpringCloudOfflineNoticeEnable()) {
            return;
        }
        if (remoteIpList.size() >= MicroServiceConfig.getRemoteAddressSize()) {
            SpringCloudActiveNoticeManager.cleanExpiredRemoteIp();
        }
        if (remoteIpList.size() >= MicroServiceConfig.getRemoteAddressSize()) {
            if (ThreadLocalRandom.current().nextInt(0, 100) < 5) {
                LOGGER.warn("[SC_OFFLINE_ACTIVE_NOTICE] SpringCloudActiveNoticeManager addRemoteIp fail, size:{}", (Object)remoteIpList.size());
            }
            return;
        }
        if (!remoteIpList.containsKey(remoteIp)) {
            LOGGER.warn("[SC_OFFLINE_ACTIVE_NOTICE] add address to remoteAddressMap, remoteIp={}", (Object)remoteIp);
        }
        remoteIpList.put(remoteIp, System.currentTimeMillis());
    }

    public static synchronized String activeNotice() {
        if (!MicroServiceConfig.isSpringCloudOfflineNoticeEnable()) {
            LOGGER.warn("[SC_OFFLINE_ACTIVE_NOTICE] is Spring Cloud Active Notice enabled: false");
            return "enable false";
        }
        if (remoteIpList.isEmpty()) {
            LOGGER.warn("[SC_OFFLINE_ACTIVE_NOTICE] remoteAddressMap is empty.");
            return "no remoteIp collected";
        }
        LOGGER.warn("[SC_OFFLINE_ACTIVE_NOTICE] Start active notice all consumers.");
        long start = System.currentTimeMillis();
        StringBuilder res = new StringBuilder();
        try {
            Enumeration<String> enumeration = remoteIpList.keys();
            while (enumeration.hasMoreElements()) {
                String ip = enumeration.nextElement();
                Long lastInvokeTime = remoteIpList.get(ip);
                if (System.currentTimeMillis() - lastInvokeTime > 300000L) {
                    remoteIpList.remove(ip);
                    continue;
                }
                if ("127.0.0.1".equals(ip) || "localhost".equals(ip)) {
                    remoteIpList.remove(ip);
                    continue;
                }
                if (System.currentTimeMillis() - start > (long)(ACTIVE_NOTICE_TIMEOUT_SECONDS * 1000)) {
                    LOGGER.warn("[SC_OFFLINE_ACTIVE_NOTICE] Active notice takes too long! Stop notice rest. RemoteIpList size: {}", (Object)remoteIpList.size());
                    break;
                }
                String offlineCallUrl = SpringCloudActiveNoticeManager.buildOfflineUrl(ip);
                String noticeResult = SpringCloudActiveNoticeManager.goAway(offlineCallUrl);
                LOGGER.warn("[SC_OFFLINE_ACTIVE_NOTICE] consumer url: {}, result: {}", (Object)offlineCallUrl, (Object)noticeResult);
                res.append(noticeResult);
            }
        }
        catch (Exception e) {
            LOGGER.error("[SC_OFFLINE_ACTIVE_NOTICE] active notice failed.", e);
        }
        LOGGER.warn("[SC_OFFLINE_ACTIVE_NOTICE] End active notice, cost: {}ms", (Object)(System.currentTimeMillis() - start));
        return res.toString();
    }

    private static String buildOfflineUrl(String host) {
        String url = "http://" + host + ":55199/" + MicroServiceConfig.MICRO_SERVICE_QOS_COMMAND_HEALTH;
        url = url + "?action=offline";
        url = url + "&serverIp=" + MicroServiceUtil.getSpringCloudServerIp();
        url = url + "&serverPort=" + MicroServiceUtil.getSpringCloudServerPort();
        url = url + "&serverName=" + MicroServiceUtil.getSpringCloudServerName();
        try {
            url = url + "&providerAppId=" + URLEncoder.encode(AgentInfo.INSTANCE.getMseAppId(), "UTF-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return url;
    }

    private static String goAway(String url) {
        return HttpGet.httpGet(url, 500, 500, HttpGet.emptyHeader);
    }

    private static boolean expired(long now, long value) {
        return now - value > (long)MicroServiceConfig.getRemoteAddressExpireTime();
    }

    public static void cleanExpiredRemoteIp() {
        long now = System.currentTimeMillis();
        Enumeration<String> enumeration = remoteIpList.keys();
        while (enumeration.hasMoreElements()) {
            Long value;
            String key = enumeration.nextElement();
            if (key == null || (value = remoteIpList.get(key)) == null || !SpringCloudActiveNoticeManager.expired(now, value)) continue;
            remoteIpList.remove(key);
        }
    }

    public static int calculateActiveNoticeTimeoutSeconds() {
        int timeout = 30;
        String preStopSleepTimeStr = System.getProperty(K8S_PRE_STOP_SLEEP_TIME_CONFIG_KEY, System.getenv(K8S_PRE_STOP_SLEEP_TIME_CONFIG_KEY));
        if (preStopSleepTimeStr != null) {
            try {
                timeout = Integer.parseInt(preStopSleepTimeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (int)Math.ceil((double)timeout * 0.66);
    }
}

