/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import java.util.concurrent.ConcurrentHashMap;

public class NoticedConsumersCollection {
    private static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(NoticedConsumersCollection.class.getName());
    private static final ConcurrentHashMap<String, NoticedPair> HAS_NOTIFIED_CONSUMERS = new ConcurrentHashMap();

    public ConcurrentHashMap<String, NoticedPair> getHasNotifiedConsumers() {
        return HAS_NOTIFIED_CONSUMERS;
    }

    public void recordNoticedConsumer(String remoteAddr, String appId, Long noticedTime) {
        if (HAS_NOTIFIED_CONSUMERS.size() > MicroServiceConfig.getRemoteAddressSize()) {
            return;
        }
        NoticedPair last = HAS_NOTIFIED_CONSUMERS.putIfAbsent(remoteAddr, new NoticedPair(noticedTime, false));
        if (last == null) {
            LOGGER.warn("[SC_OFFLINE_PASSIVE_NOTIFY] passively notify remote consumer {}", (Object)remoteAddr);
            return;
        }
        if (System.currentTimeMillis() - last.getNoticedTime() > 10000L && !last.getLogged().booleanValue()) {
            last.setLogged(true);
            LOGGER.warn("[SC_OFFLINE_PASSIVE_NOTIFY] [WARNING] already notified consumer[ADDRESS:{},APPID:{}] 10 second ago, but still received request from it", (Object)remoteAddr, (Object)appId);
        }
    }

    protected static class NoticedPair {
        private Long noticedTime;
        private Boolean logged;

        public NoticedPair(Long noticedTime, Boolean logged) {
            this.noticedTime = noticedTime;
            this.logged = logged;
        }

        public Boolean getLogged() {
            return this.logged;
        }

        public void setLogged(Boolean logged) {
            this.logged = logged;
        }

        public Long getNoticedTime() {
            return this.noticedTime;
        }

        public void setNoticedTime(Long noticedTime) {
            this.noticedTime = noticedTime;
        }
    }
}

