/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.lossless;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.ClassLoadUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.MicroServiceUtil;
import java.lang.reflect.Method;

public class CommonShutdownTool {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(CommonShutdownTool.class.getName());

    public static void updateEurekaStatus(String status, String reason) {
        try {
            Object applicationInfoManager = MicroServiceUtil.EUREKA_MULTI_REGISTRY_MAP.get("applicationInfoManager");
            if (applicationInfoManager == null) {
                return;
            }
            logger.warn("[{}] update status to: {}", (Object)reason, (Object)status);
            Class<?> clazz = applicationInfoManager.getClass();
            Class<?> statusClazz = clazz.getClassLoader().loadClass("com.netflix.appinfo.InstanceInfo$InstanceStatus");
            Method toEnum = ClassLoadUtils.getMethod(statusClazz, "toEnum", clazz.getClassLoader().loadClass("java.lang.String"));
            Object downUpStatus = ClassLoadUtils.invokeMethod(toEnum, null, status);
            Method setStatusMethod = ClassLoadUtils.getMethod(clazz, "setInstanceStatus", statusClazz);
            ClassLoadUtils.invokeMethod(setStatusMethod, applicationInfoManager, downUpStatus);
        }
        catch (Throwable t) {
            logger.warn("[{}] failed to update eureka status", (Object)reason, (Object)t);
        }
    }

    public static interface SkipRegisterAction {
        public void skipRegister(Object var1) throws Exception;
    }
}

