/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.bootstrap;

import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceCommonUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.bootstrap.MseProperty;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MseFeature {
    private static final Pattern EDAS_ID_PATTERN = Pattern.compile("[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}");

    public static boolean isCloudProductMseEnable() {
        boolean mseEnable;
        try {
            mseEnable = Boolean.parseBoolean(MicroServiceCommonUtil.getConfigProperty("mse.enable", "true"));
        }
        catch (Exception e) {
            mseEnable = true;
        }
        if (!mseEnable) {
            return false;
        }
        return MseProperty.instance.MSE_LICENSE_KEY != null && MseProperty.instance.MSE_LICENSE_KEY.contains("@");
    }

    public static boolean isMseProVersion() {
        return "pro".equals(MseProperty.instance.MSE_VERSION) || "ent".equals(MseProperty.instance.MSE_VERSION) && MicroServiceConfig.isSentinelDegraded();
    }

    public static boolean isCloudProductEdasEnable() {
        if ("Serverless".equals(MseProperty.instance.agentEnv) || "ServerlessV2".equals(MseProperty.instance.agentEnv)) {
            return false;
        }
        return MseProperty.instance.edasTenantId != null && !MseProperty.instance.edasTenantId.isEmpty() && MseFeature.checkEDASPattern(MseProperty.instance.edasTenantId) && MseProperty.instance.edasProjectName != null && !MseProperty.instance.edasProjectName.isEmpty() && MseFeature.checkEDASPattern(MseProperty.instance.edasProjectName);
    }

    private static boolean checkEDASPattern(String id) {
        Matcher matcher = EDAS_ID_PATTERN.matcher(id);
        return matcher.matches();
    }
}

