/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.auth;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.JsonMarshaler;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Callback;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.auth.AuthConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.auth.MseServiceAuth;

@Endpoint(value=ConfigEnum.MSE_APP_CONFIG_ENDPOINT)
@Namespace(value=ConfigEnum.MSE_APP_CONFIG_NAMESPACE)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
public class MseAuthState
extends State {
    public static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(MseAuthState.class.getName());

    public MseAuthState() {
        super.registerConfigInstance(this);
    }

    @DataId(value=ConfigEnum.MSE_AUTH_DUBBO_CONFIG_DATA_ID)
    @Callback
    public void onDubboConfigUpdated(String config) {
        logger.warn("[ServiceAuth] dubbo auth rule change to = {}", (Object)config);
        this.onConfigUpdated0(config);
    }

    @DataId(value=ConfigEnum.MSE_AUTH_SPRING_CLOUD_CONFIG_DATA_ID)
    @Callback
    public void onSpringCloudConfigUpdated(String config) {
        logger.warn("[ServiceAuth] spring cloud auth rule change to = {}", (Object)config);
        this.onConfigUpdated0(config);
    }

    private void onConfigUpdated0(String content) {
        if (StringUtils.isBlank(content)) {
            return;
        }
        try {
            JsonMarshaler jsonMarshaler = GlobalInstanceHolder.getInstance(JsonMarshaler.class);
            MseServiceAuth mseServiceAuth = jsonMarshaler.parseObject(content, MseServiceAuth.class);
            if ("DUBBO".equals(mseServiceAuth.getProtocol())) {
                AuthConstants.dubboApplicationRule.updateRule(mseServiceAuth);
            } else if ("SPRING_CLOUD".equals(mseServiceAuth.getProtocol())) {
                AuthConstants.scApplicationRule.updateRule(mseServiceAuth);
            }
        }
        catch (Throwable t) {
            logger.error("[mse-auth] auth rule parse error: {} ", (Object)content, (Object)t);
        }
    }
}

