/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse.auth;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.auth.MseServiceAuth;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.auth.ServiceRule;
import java.util.concurrent.ConcurrentHashMap;

public class ApplicationRule {
    private static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(ApplicationRule.class.getName());
    private ConcurrentHashMap<String, ServiceRule> services = new ConcurrentHashMap();
    private boolean enable = false;
    private String protocol = "DUBBO";
    private boolean enableAntiReplay = false;
    private Integer expirationTime = 30;

    public boolean isEnable() {
        return this.enable;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isEnableAntiReplay() {
        return this.enableAntiReplay;
    }

    public void setEnableAntiReplay(boolean enableAntiReplay) {
        this.enableAntiReplay = enableAntiReplay;
    }

    public Integer getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Integer expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean couldPass(String consumerAppId, String consumerMseGatewayId, String method) {
        if (!this.enable) {
            return true;
        }
        ServiceRule serviceRule = this.getServiceRule(method);
        if (serviceRule != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[ServiceRule] rule:" + serviceRule + " consumerAppId:" + consumerAppId + ", consumerMseGatewayId:" + consumerMseGatewayId + ", method:" + method);
            }
            if (serviceRule.getConsumers() == null || serviceRule.getConsumers().isEmpty()) {
                return serviceRule.couldPass(consumerAppId);
            }
            return serviceRule.couldPass(consumerAppId, consumerMseGatewayId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[ServiceRule] No rule set for this method, consumerAppId:" + consumerAppId + ", consumerMseGatewayId:" + consumerMseGatewayId + ", method:" + method);
        }
        return false;
    }

    public ServiceRule getServiceRule(String method) {
        ServiceRule serviceRule = this.services.get(method);
        if (serviceRule == null) {
            serviceRule = this.services.get("*");
        }
        return serviceRule;
    }

    public boolean containSingleMethodRule(String method) {
        return this.services.get(method) != null;
    }

    public boolean containMethodRule(String method) {
        return this.getServiceRule(method) != null;
    }

    public boolean isPublicAccess(String method) {
        try {
            ServiceRule serviceRule = this.getServiceRule(method);
            if (serviceRule != null) {
                return serviceRule.isPublicAccess();
            }
        }
        catch (Throwable t) {
            LOGGER.error("error occurs: ", t);
        }
        return false;
    }

    public boolean isNeedAuth() {
        return true;
    }

    public void updateRule(MseServiceAuth mseServiceAuth) {
        this.enable = mseServiceAuth.getStatus() == 1 && mseServiceAuth.getEnable() != false;
        this.protocol = mseServiceAuth.getProtocol();
        if (mseServiceAuth.getEnableAntiReplay() != null) {
            this.enableAntiReplay = mseServiceAuth.getEnableAntiReplay();
        }
        if (mseServiceAuth.getExpirationTime() != null) {
            this.expirationTime = mseServiceAuth.getExpirationTime();
        }
        ConcurrentHashMap<String, ServiceRule> tmpServices = new ConcurrentHashMap<String, ServiceRule>();
        for (MseServiceAuth.AuthRule authRule : mseServiceAuth.getAuthRule()) {
            ServiceRule serviceRule = new ServiceRule();
            if (authRule.getAll() != null && authRule.getAll().booleanValue()) {
                serviceRule.setServiceName("*");
            }
            if (authRule.getMethod() != null && authRule.getMethod().valid()) {
                serviceRule.setServiceName(authRule.getMethod().simpleName());
            }
            if (!StringUtils.isEmpty(authRule.getPath())) {
                serviceRule.setServiceName(authRule.getPath());
            }
            serviceRule.setBlack(authRule.getBlack());
            if (authRule.getAppIds() != null) {
                for (String consumerAppId : authRule.getAppIds()) {
                    serviceRule.getConsumerAppIdList().add(consumerAppId);
                }
            }
            if (authRule.getConsumers() != null) {
                for (MseServiceAuth.AuthConsumer consumer : authRule.getConsumers()) {
                    serviceRule.getConsumers().add(consumer);
                }
            }
            tmpServices.put(serviceRule.getServiceName(), serviceRule);
        }
        this.services = tmpServices;
    }

    public ConcurrentHashMap<String, ServiceRule> getServices() {
        return this.services;
    }

    public void setServices(ConcurrentHashMap<String, ServiceRule> services) {
        this.services = services;
    }

    public String toString() {
        return "ApplicationRule{services=" + this.services + ", enable=" + this.enable + ", protocol='" + this.protocol + '\'' + ", enableAntiReplay=" + this.enableAntiReplay + ", expirationTime=" + this.expirationTime + ", LOGGER=" + LOGGER + '}';
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

