/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.mse;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.AgentInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.dto.HostMetaData;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils.ArmsRuntimeMXBeanUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.AppTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MicroServiceConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MscAccount;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.MseConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.ClassUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.JSON;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class MicroServiceCommonUtil {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(MicroServiceCommonUtil.class.getName());
    private static volatile Integer pid = null;
    public static volatile Long startTime = null;
    private static volatile MscAccount mscAccount = null;
    private static final String MSE_SERVICE_CODE_BASIC_VERSION = "0";
    private static final String MSE_SERVICE_CODE_PRO_VERSION = "1";
    private static final String MSE_SERVICE_CODE_ENT_VERSION = "2";
    private static int appType = AppTypeEnum.DEFAULT.getCode();
    private static boolean EDAS_SCG_APP_FLAG = false;
    private static volatile boolean APP_MQ_ENABLE = false;
    private static final String MQ_FILTER_SERVER = "Server";
    private static final String MQ_FILTER_CLIENT = "Client";
    private static volatile String MQ_FILTER_SIDE = "Client";
    private static String appId = "";
    private static String tenantId = "";
    private static String region = "";
    private static String projectName = "";
    private static String springProjectName = "";
    private static Integer webServerPort = -1;
    protected static String zoneId = "";
    private static boolean springCloudApplication = false;

    public static boolean isAppMqEnable() {
        return APP_MQ_ENABLE;
    }

    public static void setAppMqEnable(boolean appMqEnable) {
        APP_MQ_ENABLE = appMqEnable;
    }

    public static boolean isMqServerGrayEnable() {
        return MQ_FILTER_SERVER.equals(MQ_FILTER_SIDE);
    }

    public static void setMqFilterSide(String filterSide) {
        MQ_FILTER_SIDE = filterSide;
    }

    public static boolean isTagListStringEmpty(String tagList) {
        return StringUtils.isEmpty(tagList) || "[]".equals(tagList);
    }

    public static boolean isMseProVersion() {
        if (mscAccount != null && MSE_SERVICE_CODE_PRO_VERSION.equals(mscAccount.getVersion() + "")) {
            return true;
        }
        if (mscAccount != null && MSE_SERVICE_CODE_ENT_VERSION.equals(mscAccount.getVersion() + "")) {
            return true;
        }
        if (mscAccount != null && MSE_SERVICE_CODE_BASIC_VERSION.equals(mscAccount.getVersion() + "")) {
            return false;
        }
        if ("pro".equals(MicroServiceConfig.MSE_VERSION)) {
            return true;
        }
        return "ent".equals(MicroServiceConfig.MSE_VERSION);
    }

    public static boolean isMseEntVersion() {
        if (mscAccount != null && MSE_SERVICE_CODE_ENT_VERSION.equals(mscAccount.getVersion() + "")) {
            return true;
        }
        return "ent".equals(MicroServiceConfig.MSE_VERSION);
    }

    public static boolean isEdasVersion() {
        if (mscAccount != null && MSE_SERVICE_CODE_PRO_VERSION.equals(mscAccount.getVersion() + "")) {
            return true;
        }
        return mscAccount != null && MSE_SERVICE_CODE_ENT_VERSION.equals(mscAccount.getVersion() + "");
    }

    public static void setMscAccount(MscAccount mscAccount) {
        MicroServiceCommonUtil.mscAccount = mscAccount;
    }

    public static int getPid() {
        if (pid == null) {
            pid = ArmsRuntimeMXBeanUtils.getPid();
            MicroServiceCommonUtil.setPid(pid);
        }
        return pid;
    }

    public static void setPid(int pid) {
        MicroServiceCommonUtil.pid = pid;
    }

    public static Integer getWebServerPort() {
        return webServerPort;
    }

    public static void setWebServerPort(Integer webServerPort) {
        MicroServiceCommonUtil.webServerPort = webServerPort;
    }

    public static void setSpringProjectName(String springProjectName) {
        MicroServiceCommonUtil.springProjectName = springProjectName;
    }

    public static String getSpringProjectName() {
        return springProjectName;
    }

    public static boolean isSpringCloudApplication() {
        return springCloudApplication;
    }

    public static void setSpringCloudApplication(boolean springCloudApplication) {
        MicroServiceCommonUtil.springCloudApplication = springCloudApplication;
    }

    public static void setProjectName(String projectName) {
        if (StringUtils.isEmpty(MicroServiceCommonUtil.projectName)) {
            MicroServiceCommonUtil.projectName = projectName;
        }
    }

    public static String getSystemParameter(String key, String def) {
        String value = System.getProperty(key, System.getenv(key));
        if (value == null) {
            return def;
        }
        return value;
    }

    public static String getConfigProperty(String key, String def) {
        String value = System.getProperty(key, System.getenv(key));
        if (value == null) {
            return ConfigPropertiesUtil.getString(key, def);
        }
        return value;
    }

    public static String[] parameterTypes(String methodName, Class serviceInterface, Class[] serviceParameterTypes) {
        List<Method> methods = ClassUtils.getPublicNonStaticMethods(serviceInterface);
        for (Method reflectmethod : methods) {
            Object[] paramTypes = reflectmethod.getParameterTypes();
            if (!methodName.equals(reflectmethod.getName()) || !Arrays.equals(paramTypes, serviceParameterTypes)) continue;
            String[] parameterTypes = new String[paramTypes.length];
            Type[] genericParamTypes = reflectmethod.getGenericParameterTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                parameterTypes[i] = genericParamTypes[i] instanceof Class ? ((Class)genericParamTypes[i]).getName() : genericParamTypes[i].toString();
            }
            return parameterTypes;
        }
        return null;
    }

    public static String getSystemParameterWithoutDefaultValue(String key) {
        return System.getProperty(key, System.getenv(key));
    }

    public static String getZoneId() {
        HostMetaData metaData;
        if (StringUtils.isEmpty(zoneId) && !StringUtils.isEmpty(AgentInfo.INSTANCE.getHostMetadata()) && (metaData = JSON.parseObject(AgentInfo.INSTANCE.getHostMetadata(), HostMetaData.class)) != null) {
            zoneId = metaData.getZoneId();
        }
        return zoneId;
    }

    public static String getAppId() {
        if (StringUtils.isEmpty(appId)) {
            if ("Serverless".equals(MseConstants.agentEnv)) {
                appId = MseConstants.appId;
                return appId;
            }
            appId = projectName;
            if (StringUtils.isEmpty(appId)) {
                appId = MseConstants.appId;
            }
        }
        return appId;
    }

    public static String getTenantId() {
        if (StringUtils.isEmpty(tenantId)) {
            if ("Serverless".equals(MseConstants.agentEnv)) {
                tenantId = MseConstants.licenseKey;
                return tenantId;
            }
            if (MseConstants.mode.equals("EDAS")) {
                tenantId = MicroServiceCommonUtil.getSystemParameterWithoutDefaultValue("tenant.id");
                return tenantId;
            }
            if (MseConstants.mode.equals("MSC") || MseConstants.mode.equals("ARMS&MSC")) {
                tenantId = MseConstants.licenseKey;
                return tenantId;
            }
            tenantId = MicroServiceCommonUtil.getSystemParameterWithoutDefaultValue("tenant.id");
            if (StringUtils.isEmpty(tenantId)) {
                tenantId = MseConstants.licenseKey;
            }
        }
        return tenantId;
    }

    public static String getUrlWithoutParameters(String url) throws URISyntaxException {
        URI uri = new URI(url);
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        String path = uri.getPath();
        String fragment = uri.getFragment();
        return new URI(scheme, authority, path, null, fragment).toString();
    }

    public static String getAgentMode() {
        if (MseConstants.mode.equals("MSC") || MseConstants.mode.equals("ARMS&MSC") || "Serverless".equals(MseConstants.agentEnv)) {
            return "edasmsc";
        }
        return MseConstants.mode;
    }

    public static String getRegion() {
        if (StringUtils.isEmpty(region) && StringUtils.isEmpty(region = MicroServiceCommonUtil.getSystemParameterWithoutDefaultValue("profiler.acm.region.id"))) {
            region = MseConstants.regionId;
        }
        return region;
    }

    public static int getAppType() {
        if (AppTypeEnum.isValid(MicroServiceConfig.MSE_SENTINEL_APP_TYPE) && appType != MicroServiceConfig.MSE_SENTINEL_APP_TYPE) {
            MicroServiceCommonUtil.setAppType(MicroServiceConfig.MSE_SENTINEL_APP_TYPE);
            LOGGER.log(Level.WARNING, "MicroServiceCommonUtil.appType set to {} by MSE_SENTINEL_APP_TYPE", appType);
        }
        return appType;
    }

    public static void setAppType(int appType) {
        MicroServiceCommonUtil.appType = appType;
    }

    public static boolean isEdasScgAppFlag() {
        return EDAS_SCG_APP_FLAG;
    }

    public static void setEdasScgAppFlag(boolean edasScgAppFlag) {
        EDAS_SCG_APP_FLAG = edasScgAppFlag;
    }
}

