/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.threadpool;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsThreadFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.threadpool.AbstractThreadPoolMonitorRegistry;
import io.opentelemetry.javaagent.shaded.instrumentation.api.util.VirtualField;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolExecutorMonitorRegistry
extends AbstractThreadPoolMonitorRegistry<ThreadPoolExecutor> {
    public static ThreadPoolExecutorMonitorRegistry instance = new ThreadPoolExecutorMonitorRegistry();
    private VirtualField<ThreadPoolExecutor, AtomicLong> rejectedTaskCount;

    private ThreadPoolExecutorMonitorRegistry() {
    }

    @Override
    protected String getThreadPoolUsage(ThreadPoolExecutor threadPoolExecutor, String threadName) {
        String realClassName = threadPoolExecutor.getClass().getName();
        if (StringUtils.equals("org.apache.tomcat.util.threads.ThreadPoolExecutor", realClassName)) {
            return "Tomcat";
        }
        if (threadName == null) {
            threadName = "";
        }
        if (threadName.startsWith("vert.x")) {
            return "Vertx";
        }
        ThreadGroup currentGroup = Thread.currentThread().getThreadGroup();
        if (ArmsThreadFactory.group.equals(currentGroup) || currentGroup != null && currentGroup.getName().equals("aliyun-mse-thread-group")) {
            return "AliyunJavaAgent";
        }
        return super.getThreadPoolUsage(threadPoolExecutor, threadName);
    }

    @Override
    protected long getCorePoolSizeFromPool(ThreadPoolExecutor threadPool) {
        return threadPool.getCorePoolSize();
    }

    @Override
    protected long getMaxPoolSizeFromPool(ThreadPoolExecutor threadPool) {
        return threadPool.getMaximumPoolSize();
    }

    @Override
    protected long getActiveThreadCountFromPool(ThreadPoolExecutor threadPool) {
        return threadPool.getActiveCount();
    }

    @Override
    protected long getCurrentThreadCountFromPool(ThreadPoolExecutor threadPool) {
        return threadPool.getPoolSize();
    }

    @Override
    protected long getMaxThreadCountFromPool(ThreadPoolExecutor threadPool) {
        return threadPool.getLargestPoolSize();
    }

    @Override
    protected long getScheduledTaskCountFromPool(ThreadPoolExecutor threadPool) {
        return threadPool.getTaskCount();
    }

    @Override
    protected long getCompletedTaskCountFromPool(ThreadPoolExecutor threadPool) {
        return threadPool.getCompletedTaskCount();
    }

    @Override
    protected long getQueueSizeFromPool(ThreadPoolExecutor threadPool) {
        return threadPool.getQueue().size();
    }

    @Override
    protected long getRejectedTaskCountFromPool(ThreadPoolExecutor threadPool) {
        if (this.rejectedTaskCount == null) {
            return -1L;
        }
        AtomicLong atomicLong = this.rejectedTaskCount.get(threadPool);
        if (atomicLong == null) {
            return -1L;
        }
        return atomicLong.get();
    }

    public void setRejectedTaskCount(VirtualField<ThreadPoolExecutor, AtomicLong> rejectedTaskCount) {
        this.rejectedTaskCount = rejectedTaskCount;
    }
}

