/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.threadpool;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import javax.annotation.Nullable;

public class ThreadPoolAttributes {
    static final AttributeKey<String> POOL_NAME = AttributeKey.stringKey("thread_pool_class_name");
    static final AttributeKey<String> CREATE_STACK = AttributeKey.stringKey("thread_pool_create_stack");
    static final AttributeKey<String> THREAD_NAME_PATTERN = AttributeKey.stringKey("thread_name_pattern");
    static final AttributeKey<String> POOL_USAGE = AttributeKey.stringKey("thread_pool_usage");
    static final String UNKNOWN_CREATE_STACK = "0000000000000000";
    private Attributes attributes;

    public static ThreadPoolAttributes create(String poolClassName, @Nullable String createStackId, String threadNamePattern, String threadPoolUsage) {
        if (StringUtils.isEmpty(createStackId)) {
            createStackId = UNKNOWN_CREATE_STACK;
        }
        return new ThreadPoolAttributes(Attributes.of(POOL_NAME, poolClassName, CREATE_STACK, createStackId, THREAD_NAME_PATTERN, threadNamePattern, POOL_USAGE, threadPoolUsage));
    }

    ThreadPoolAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public synchronized Attributes getAttributes() {
        return this.attributes;
    }

    public synchronized void updateThreadPoolUsage(String usage) {
        this.attributes = this.attributes.toBuilder().put(POOL_USAGE, usage).build();
    }

    public synchronized void updateThreadPoolCreateStack(String createStackId) {
        if (StringUtils.isEmpty(createStackId)) {
            return;
        }
        this.attributes = this.attributes.toBuilder().put(CREATE_STACK, createStackId).build();
    }
}

