/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.threadpool;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.CommonUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils.MethodStack;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.exception.ArmsExceptionRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.threadpool.ThreadNamePatternExtractStrategy;
import io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.threadpool.ThreadPoolAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.metrics.threadpool.ThreadPoolMonitorState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.jsr166.ConcurrentWeakHashMap;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractThreadPoolMonitorRegistry<T> {
    private static final PatchLogger logger = PatchLogger.getLogger(AbstractThreadPoolMonitorRegistry.class.getName());
    private final Map<T, ThreadPoolAttributes> threadPoolExecutorMonitorMap = new ConcurrentWeakHashMap<T, ThreadPoolAttributes>();
    private final Map<T, MethodStack> monitor2InitCallstack = new ConcurrentWeakHashMap<T, MethodStack>();
    private final Map<T, String> threadPoolUsage = new ConcurrentWeakHashMap<T, String>();
    public ObservableLongMeasurement corePoolSize;
    public ObservableLongMeasurement maxPoolSize;
    public ObservableLongMeasurement activeThreadCount;
    public ObservableLongMeasurement currentThreadCount;
    public ObservableLongMeasurement maxThreadCount;
    public ObservableLongMeasurement scheduledTaskCount;
    public ObservableLongMeasurement completedTaskCount;
    public ObservableLongMeasurement rejectedTaskCount;
    public ObservableLongMeasurement queueSize;
    private BatchCallback batchCallback;

    public AbstractThreadPoolMonitorRegistry() {
        this.initMetrics(GlobalOpenTelemetry.getMeterProvider());
    }

    public void setMeterProvider(MeterProvider meterProvider) {
        this.initMetrics(meterProvider);
    }

    private void initMetrics(MeterProvider meterProvider) {
        if (this.batchCallback != null) {
            this.batchCallback.close();
        }
        String instrumentationName = "thread-pool";
        MeterBuilder meterBuilder = meterProvider.meterBuilder(instrumentationName);
        String version = EmbeddedInstrumentationProperties.findVersion(instrumentationName);
        if (version != null) {
            meterBuilder.setInstrumentationVersion(version);
        }
        Meter meter = meterBuilder.build();
        this.corePoolSize = meter.gaugeBuilder("arms_thread_pool_core_pool_size").setUnit("1").setDescription("the core number of threads").ofLongs().buildObserver();
        this.maxPoolSize = meter.gaugeBuilder("arms_thread_pool_max_pool_size").setUnit("1").setDescription("the maximum allowed number of threads.").ofLongs().buildObserver();
        this.activeThreadCount = meter.gaugeBuilder("arms_thread_pool_active_thread_count").setUnit("1").setDescription("the approximate number of threads that are actively executing tasks.").ofLongs().buildObserver();
        this.currentThreadCount = meter.gaugeBuilder("arms_thread_pool_current_thread_count").setUnit("1").setDescription("the current number of threads in the pool.").ofLongs().buildObserver();
        this.maxThreadCount = meter.gaugeBuilder("arms_thread_pool_max_thread_count").setUnit("{1}").setDescription("the largest number of threads that have ever simultaneously been in the pool").ofLongs().buildObserver();
        this.scheduledTaskCount = meter.upDownCounterBuilder("arms_thread_pool_scheduled_task_count").setUnit("{1}").setDescription("the approximate total number of tasks that have ever been scheduled for execution.").buildObserver();
        this.completedTaskCount = meter.upDownCounterBuilder("arms_thread_pool_completed_task_count").setUnit("{1}").setDescription("the approximate total number of tasks that have completed execution.").buildObserver();
        this.rejectedTaskCount = meter.upDownCounterBuilder("arms_thread_pool_rejected_task_count").setUnit("{1}").setDescription("the approximate total number of tasks that has been rejected.").buildObserver();
        this.queueSize = meter.gaugeBuilder("arms_thread_pool_queue_size").setUnit("{1}").setDescription("the task queue size").ofLongs().buildObserver();
        this.batchCallback = meter.batchCallback(this::recordThreadPoolGuageMetrics, this.corePoolSize, this.maxPoolSize, this.activeThreadCount, this.currentThreadCount, this.maxThreadCount, this.scheduledTaskCount, this.completedTaskCount, this.rejectedTaskCount, this.queueSize);
    }

    public void recordThreadPoolCreateStack(T executor, MethodStack stack) {
        this.monitor2InitCallstack.put(executor, stack);
        ThreadPoolAttributes threadPoolAttributes = this.threadPoolExecutorMonitorMap.get(executor);
        if (threadPoolAttributes != null) {
            threadPoolAttributes.updateThreadPoolCreateStack(this.getThreadCreateStackIdByStack(stack));
        }
    }

    public synchronized void registerThreadPoolExecutor(T threadPoolExecutor, String threadName) {
        if (!ThreadPoolMonitorState.getInstance().isThreadPoolMonitorRegisterEnable()) {
            return;
        }
        if (this.threadPoolExecutorMonitorMap.size() >= ThreadPoolMonitorState.getInstance().getMonitoredThreadPoolThreshold() && this.notInWhiteList(threadPoolExecutor, threadName)) {
            logger.info("Registered Thread Pool exceed thresholds current size = " + this.threadPoolExecutorMonitorMap.size());
            return;
        }
        if (this.threadPoolExecutorMonitorMap.containsKey(threadPoolExecutor)) {
            return;
        }
        String usage = this.threadPoolUsage.get(threadPoolExecutor);
        if (usage == null) {
            usage = this.getThreadPoolUsage(threadPoolExecutor, threadName);
        }
        ThreadPoolAttributes threadPoolAttributes = ThreadPoolAttributes.create(threadPoolExecutor.getClass().getName(), this.getThreadCreateStackId(threadPoolExecutor), this.getThreadNamePattern(threadName), usage);
        this.threadPoolExecutorMonitorMap.put(threadPoolExecutor, threadPoolAttributes);
    }

    private String getThreadCreateStackId(T threadPoolExecutor) {
        MethodStack stack = this.monitor2InitCallstack.get(threadPoolExecutor);
        if (stack == null) {
            logger.info("ThreadPool create Stack not found, thread()");
            return null;
        }
        return this.getThreadCreateStackIdByStack(stack);
    }

    private String getThreadCreateStackIdByStack(MethodStack methodStack) {
        ArmsExceptionRecorder recorder = GlobalInstanceHolder.getInstance(ArmsExceptionRecorder.class);
        if (recorder != null) {
            return recorder.recordException(methodStack.getStack()).getExcepInfoId();
        }
        return null;
    }

    private boolean notInWhiteList(T threadPoolExecutor, String threadName) {
        String threadNamePattern = this.getThreadNamePattern(threadName);
        String usage = this.getThreadPoolUsage(threadPoolExecutor, threadName);
        return !ThreadPoolMonitorState.getInstance().isInWhitelist(usage, threadNamePattern);
    }

    private String getThreadNamePattern(String threadName) {
        if (ThreadPoolMonitorState.getInstance().getThreadNamePatternExtractStrategy() == ThreadNamePatternExtractStrategy.REPLACE_ALL_DIGITAL) {
            return CommonUtils.replaceDigitalChars(threadName, '*');
        }
        return CommonUtils.replaceTailDigitalChars(threadName, '*');
    }

    public synchronized void updateThreadPoolUsage(T threadPoolExecutor, String usage) {
        ThreadPoolAttributes metrics = this.threadPoolExecutorMonitorMap.get(threadPoolExecutor);
        if (metrics != null) {
            metrics.updateThreadPoolUsage(usage);
        } else {
            this.threadPoolUsage.put(threadPoolExecutor, usage);
        }
    }

    public void unRegisterThreadPoolExecutor(T threadPool) {
        this.threadPoolExecutorMonitorMap.remove(threadPool);
    }

    protected String getThreadPoolUsage(T threadPoolExecutor, String threadName) {
        return "default";
    }

    private void selfMonitor() {
        ThreadPoolMonitorState.getInstance().setRegisteredThreadCount(this.threadPoolExecutorMonitorMap.size());
        ThreadPoolMonitorState.getInstance().updateLastScheduleTime();
    }

    public void recordThreadPoolGuageMetrics() {
        this.selfMonitor();
        if (!ThreadPoolMonitorState.getInstance().isThreadPoolMonitorEnable()) {
            return;
        }
        HashMap<Attributes, List> groupedThreadPoolMetrics = new HashMap<Attributes, List>();
        HashMap attributes2ThreadPoolMetrics = new HashMap();
        for (Map.Entry<T, ThreadPoolAttributes> entry : this.threadPoolExecutorMonitorMap.entrySet()) {
            Attributes attributes = entry.getValue().getAttributes();
            String usage = attributes.get(ThreadPoolAttributes.POOL_USAGE);
            String pattern = attributes.get(ThreadPoolAttributes.THREAD_NAME_PATTERN);
            if (ThreadPoolMonitorState.getInstance().isInBlacklist(usage, pattern)) continue;
            List ls = groupedThreadPoolMetrics.computeIfAbsent(attributes, k -> {
                attributes2ThreadPoolMetrics.put(k, (ThreadPoolAttributes)metricsEntry.getValue());
                return new LinkedList();
            });
            ls.add(entry.getKey());
        }
        for (Map.Entry<Object, ThreadPoolAttributes> entry : groupedThreadPoolMetrics.entrySet()) {
            ThreadPoolAttributes metrics = (ThreadPoolAttributes)attributes2ThreadPoolMetrics.get(entry.getKey());
            this.doRecordMetrics((List)((Object)entry.getValue()), metrics);
        }
    }

    void doRecordMetrics(List<T> threadPoolExecutors, ThreadPoolAttributes threadpoolAttributes) {
        if (threadPoolExecutors == null || threadPoolExecutors.size() == 0) {
            return;
        }
        long corePoolSize = 0L;
        long maxPoolSize = 0L;
        long activeThreadCount = 0L;
        long currentThreadCount = 0L;
        long maxThreadCount = 0L;
        long queueSize = 0L;
        long completedTaskCount = 0L;
        long scheduledTaskCount = 0L;
        long rejectedTaskCount = 0L;
        for (T threadPoolExecutor : threadPoolExecutors) {
            corePoolSize += this.getCorePoolSizeFromPool(threadPoolExecutor);
            maxPoolSize += this.getMaxPoolSizeFromPool(threadPoolExecutor);
            activeThreadCount += this.getActiveThreadCountFromPool(threadPoolExecutor);
            currentThreadCount += this.getCurrentThreadCountFromPool(threadPoolExecutor);
            maxThreadCount += this.getMaxThreadCountFromPool(threadPoolExecutor);
            queueSize += this.getQueueSizeFromPool(threadPoolExecutor);
            completedTaskCount += this.getCompletedTaskCountFromPool(threadPoolExecutor);
            scheduledTaskCount += this.getScheduledTaskCountFromPool(threadPoolExecutor);
            rejectedTaskCount += this.getRejectedTaskCountFromPool(threadPoolExecutor);
        }
        Attributes attributes = threadpoolAttributes.getAttributes();
        int size = threadPoolExecutors.size();
        this.corePoolSize.record(corePoolSize / (long)size, attributes);
        this.maxPoolSize.record(maxPoolSize / (long)size, attributes);
        this.activeThreadCount.record(activeThreadCount / (long)size, attributes);
        this.currentThreadCount.record(currentThreadCount / (long)size, attributes);
        this.maxThreadCount.record(maxThreadCount / (long)size, attributes);
        this.queueSize.record(queueSize / (long)size, attributes);
        this.completedTaskCount.record(completedTaskCount, attributes);
        this.scheduledTaskCount.record(scheduledTaskCount, attributes);
        this.rejectedTaskCount.record(rejectedTaskCount, attributes);
    }

    protected abstract long getCorePoolSizeFromPool(T var1);

    protected abstract long getMaxPoolSizeFromPool(T var1);

    protected abstract long getActiveThreadCountFromPool(T var1);

    protected abstract long getCurrentThreadCountFromPool(T var1);

    protected abstract long getMaxThreadCountFromPool(T var1);

    protected abstract long getScheduledTaskCountFromPool(T var1);

    protected abstract long getCompletedTaskCountFromPool(T var1);

    protected abstract long getQueueSizeFromPool(T var1);

    protected abstract long getRejectedTaskCountFromPool(T var1);
}

