/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.log;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.ConfigKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext;

@Endpoint(value=ConfigEnum.ARMS_APP_CONFIG_ENDPOINT)
@DataId(value=ConfigEnum.ARMS_APP_CONFIG_DATA_ID)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
@Namespace(value=ConfigEnum.ARMS_APP_CONFIG_NAMESPACE)
public class LogTraceCorrelationState
extends ArmsState {
    @ConfigKey(value="profiler.logging.injectTraceId2Log.enable")
    private volatile boolean injectTraceId2Log = ConfigPropertiesUtil.getBoolean("profiler.logging.injectTraceId2Log.enable", false);
    @ConfigKey(value="profiler.logging.injectTraceId2Log.traceIdKey", type=String.class)
    private volatile String traceIdKey = "traceId";
    @ConfigKey(value="profiler.logging.injectSpanId2Log.enable")
    private volatile boolean injectSpanId2Log = ConfigPropertiesUtil.getBoolean("profiler.logging.injectSpanId2Log.enable", false);
    @ConfigKey(value="profiler.logging.injectSpanId2Log.spanIdKey", type=String.class)
    private volatile String spanIdKey = "spanId";
    public static LogTraceCorrelationState INSTANCE = new LogTraceCorrelationState();

    public LogTraceCorrelationState() {
        super.registerConfigInstance(this);
    }

    public void setInjectTraceId2Log(boolean injectTraceId2Log) {
        this.injectTraceId2Log = injectTraceId2Log;
    }

    public void setInjectSpanId2Log(boolean injectSpanId2Log) {
        this.injectSpanId2Log = injectSpanId2Log;
    }

    public static LogTraceCorrelationState getINSTANCE() {
        return INSTANCE;
    }

    public static void setINSTANCE(LogTraceCorrelationState INSTANCE) {
        LogTraceCorrelationState.INSTANCE = INSTANCE;
    }

    public String prependSpanContext(String msg, SpanContext spanContext) {
        StringBuilder sb = new StringBuilder();
        this.appendSpanContext(sb, spanContext);
        sb.append(msg);
        return sb.toString();
    }

    public void appendSpanContext(StringBuilder msg, SpanContext spanContext) {
        boolean valid = spanContext.isValid();
        if (this.injectTraceId2Log) {
            msg.append(this.traceIdKey).append(":").append(valid ? spanContext.getTraceId() : "").append(" ");
        }
        if (this.injectSpanId2Log) {
            msg.append(this.spanIdKey).append(":").append(valid ? spanContext.getSpanId() : "").append(" ");
        }
    }
}

