/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.CacheTracker;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.MapBackedCache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.WeakLockFreeCache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface Cache<K, V> {
    public static final CacheTracker registerCache = GlobalInstanceHolder.getInstance(CacheTracker.class);

    public static <K, V> Cache<K, V> weak() {
        WeakLockFreeCache cache = new WeakLockFreeCache();
        if (registerCache != null) {
            registerCache.registerCache(cache);
        }
        return cache;
    }

    public static <K, V> Cache<K, V> bounded(int capacity) {
        ConcurrentLinkedHashMap map = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(capacity).build();
        MapBackedCache cache = new MapBackedCache(map);
        if (registerCache != null) {
            registerCache.registerCache(cache);
        }
        return cache;
    }

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    @Nullable
    public V get(K var1);

    public void put(K var1, V var2);

    public void remove(K var1);

    public int size();
}

