/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal;

import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public final class ConfigPropertiesUtil {
    private static Map<String, String> configurationFileProperties;

    public static void setConfigurationFileProperties(Map<String, String> properties) {
        configurationFileProperties = properties;
    }

    public static boolean getBoolean(String propertyName, boolean defaultValue) {
        String strValue = ConfigPropertiesUtil.getString(propertyName);
        return strValue == null ? defaultValue : Boolean.parseBoolean(strValue);
    }

    public static int getInt(String propertyName, int defaultValue) {
        String strValue = ConfigPropertiesUtil.getString(propertyName);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    public static long getLong(String propertyName, long defaultValue) {
        String strValue = ConfigPropertiesUtil.getString(propertyName);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(strValue);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    @Nullable
    public static String getString(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        value = System.getenv(ConfigPropertiesUtil.toEnvVarName(propertyName));
        if (value != null) {
            return value;
        }
        return configurationFileProperties == null ? null : (String)configurationFileProperties.getOrDefault(propertyName, null);
    }

    @Nullable
    public static String getStringOrigin(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        value = System.getenv(propertyName);
        if (value != null) {
            return value;
        }
        return configurationFileProperties == null ? null : (String)configurationFileProperties.getOrDefault(propertyName, null);
    }

    public static String getString(String propertyName, String defaultValue) {
        String value = ConfigPropertiesUtil.getString(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String getStringOrigin(String propertyName, String defaultValue) {
        String value = ConfigPropertiesUtil.getStringOrigin(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static String toEnvVarName(String propertyName) {
        return propertyName.toUpperCase(Locale.ROOT).replace('-', '_').replace('.', '_');
    }

    private ConfigPropertiesUtil() {
    }
}

