/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.SpanUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SelfMonitorMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsCustomSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsTestProperties;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceFlags;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;

public class ArmsSpanCompressUtil {
    private static final SpanReader spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);

    public static boolean mergeChildSpan(List<ArmsCustomSpan> parentChildList, ArmsCustomSpan armsCustomSpan) {
        boolean mergeResult = false;
        for (ArmsCustomSpan child : parentChildList) {
            if (!child.compareAndMerge(armsCustomSpan)) continue;
            mergeResult = true;
            break;
        }
        return mergeResult;
    }

    public static void mergeArmsSpanAttribute(ArmsCustomSpan armsCustomSpan) {
        if (armsCustomSpan.getCount() > 1) {
            armsCustomSpan.getSpan().setAttribute("repeated.span.count", (long)armsCustomSpan.getCount());
            armsCustomSpan.getSpan().setAttribute("repeated.span.duration.max", ArmsSpanCompressUtil.toMillieSeconds(armsCustomSpan.getMax()));
            armsCustomSpan.getSpan().setAttribute("repeated.span.duration.min", ArmsSpanCompressUtil.toMillieSeconds(armsCustomSpan.getMin()));
            armsCustomSpan.getSpan().setAttribute("repeated.span.duration.total", ArmsSpanCompressUtil.toMillieSeconds(armsCustomSpan.getTotalDuration()));
            if (ArmsTestProperties.isIsInIt()) {
                return;
            }
            PriorityBlockingQueue<ArmsCustomSpan> slowSpans = armsCustomSpan.getTopK();
            List<ArmsCustomSpan> errorSpans = armsCustomSpan.getErrorSpan();
            if (slowSpans.size() > 0) {
                for (ArmsCustomSpan span : slowSpans) {
                    armsCustomSpan.getSpan().addEvent(span.getSpanName(), ArmsSpanCompressUtil.parseSpan2SpanEvent(armsCustomSpan.getSpan(), span.getSpan(), "slowerSpan", span.getDuration()), ArmsSpanCompressUtil.getStartNanos(span), TimeUnit.NANOSECONDS);
                }
            }
            if (errorSpans.size() > 0) {
                for (ArmsCustomSpan span : errorSpans) {
                    armsCustomSpan.getSpan().addEvent(span.getSpanName(), ArmsSpanCompressUtil.parseSpan2SpanEvent(armsCustomSpan.getSpan(), span.getSpan(), "errorSpan", span.getDuration()), ArmsSpanCompressUtil.getStartNanos(span), TimeUnit.NANOSECONDS);
                }
            }
        }
    }

    private static long getStartNanos(ArmsCustomSpan armsCustomSpan) {
        if (spanReader == null) {
            return -1L;
        }
        return spanReader.getSpanStartNanos(armsCustomSpan.getSpan());
    }

    private static Attributes parseSpan2SpanEvent(Span span, Span toBeParse, String sampleReason, long spanDuration) {
        if (spanReader == null) {
            return Attributes.empty();
        }
        Attributes attributes = spanReader.getAttributes(span);
        Attributes toBeParseAttributes = spanReader.getAttributes(toBeParse);
        AttributesBuilder attributesBuilder = toBeParseAttributes.toBuilder();
        toBeParseAttributes.forEach((k, v) -> {
            if (v.equals(attributes.get(k))) {
                attributesBuilder.remove(k);
            }
        });
        attributesBuilder.put("span.duration", spanDuration);
        attributesBuilder.put("span.record.reason", sampleReason);
        return attributesBuilder.build();
    }

    public static void endRootSpan(ArmsCustomSpan armsCustomSpan, boolean sampleByTailSampling, BooleanSupplier exceedSpanThresholdSupplier) {
        boolean exceedSpanThreshold = exceedSpanThresholdSupplier.getAsBoolean();
        if (armsCustomSpan.getChildArmsCustomSpanList() != null) {
            int n = armsCustomSpan.getChildArmsCustomSpanList().size();
            for (int i = 0; i < n; ++i) {
                ArmsSpanCompressUtil.endRootSpan(armsCustomSpan.getChildArmsCustomSpanList().get(i), sampleByTailSampling, exceedSpanThresholdSupplier);
            }
        }
        ArmsSpanCompressUtil.mergeArmsSpanAttribute(armsCustomSpan);
        Span span = armsCustomSpan.getSpan();
        if (exceedSpanThreshold) {
            SpanUtils.updateSampleFlag(span, TraceFlags.getDefault());
        } else if (sampleByTailSampling && !span.getSpanContext().isSampled()) {
            SpanUtils.updateSampleFlag(span, TraceFlags.getSampled());
        }
        if (armsCustomSpan.getEndTime() != 0L) {
            span.end(armsCustomSpan.getEndTime(), TimeUnit.NANOSECONDS);
            SelfMonitorMetrics.spanMemoryCount.decrementAndGet();
        } else {
            span.end();
            SelfMonitorMetrics.spanMemoryCount.decrementAndGet();
        }
        armsCustomSpan.getChildArmsCustomSpanList().clear();
    }

    private static long toMillieSeconds(long nanoTimes) {
        return nanoTimes / 1000000L;
    }
}

