/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsRpcTypeEnum;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ArmsCustomSpan {
    private int count;
    private long max;
    private long min;
    private final long duration;
    private long totalDuration;
    private final String spanName;
    private final Span span;
    private final String rpcName;
    private final int rpcType;
    private final boolean compressible;
    private final StatusCode statusCode;
    @Nullable
    private final long endTime;
    private final PriorityBlockingQueue<ArmsCustomSpan> topK;
    private final List<ArmsCustomSpan> errorSpan;
    private List<ArmsCustomSpan> childArmsCustomSpanList;
    private static final int SAMPLE_COUNT = 3;

    public ArmsCustomSpan(String spanName, int rpcType, long endTime, long duration, StatusCode statusCode, Span span) {
        this(spanName, null, rpcType, endTime, duration, statusCode, span);
    }

    public ArmsCustomSpan(String spanName, @Nullable String rpcName, int rpcType, long endTime, long duration, StatusCode statusCode, Span span) {
        this.spanName = spanName;
        this.rpcName = rpcName;
        this.rpcType = rpcType;
        this.compressible = ArmsRpcTypeEnum.isInSpanCompressible(rpcType);
        this.span = span;
        this.endTime = endTime;
        this.count = 1;
        this.max = duration;
        this.min = duration;
        this.duration = duration;
        this.totalDuration += duration;
        this.statusCode = statusCode;
        this.topK = new PriorityBlockingQueue<ArmsCustomSpan>(3, new Comparator<ArmsCustomSpan>(){

            @Override
            public int compare(ArmsCustomSpan o1, ArmsCustomSpan o2) {
                return Long.compare(o1.duration, o2.duration);
            }
        });
        this.errorSpan = new CopyOnWriteArrayList<ArmsCustomSpan>();
        this.childArmsCustomSpanList = new CopyOnWriteArrayList<ArmsCustomSpan>();
    }

    public static ArmsCustomSpan create(String spanName, @Nullable String rpcName, int rpcType, long duration, Long startTimeNanos, StatusCode statusCode, Span span) {
        long endTime = System.currentTimeMillis();
        if (startTimeNanos != 0L) {
            endTime = startTimeNanos + duration;
        }
        return new ArmsCustomSpan(spanName, rpcName, rpcType, endTime, duration, statusCode, span);
    }

    private static long getNanos(@Nullable Instant time) {
        if (time == null) {
            return System.nanoTime();
        }
        return TimeUnit.SECONDS.toNanos(time.getEpochSecond()) + (long)time.getNano();
    }

    public String getSpanName() {
        return this.spanName;
    }

    public Span getSpan() {
        return this.span;
    }

    public int getRpcType() {
        return this.rpcType;
    }

    public boolean isCompressible() {
        return this.compressible;
    }

    public boolean canEnd() {
        return this.span.getSpanContext().isSampled() && !this.compressible;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getRpcName() {
        return this.rpcName;
    }

    public PriorityBlockingQueue<ArmsCustomSpan> getTopK() {
        return this.topK;
    }

    public List<ArmsCustomSpan> getErrorSpan() {
        return this.errorSpan;
    }

    public int getCount() {
        return this.count;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public List<ArmsCustomSpan> getChildArmsCustomSpanList() {
        return this.childArmsCustomSpanList;
    }

    public void setChildArmsCustomSpanList(List<ArmsCustomSpan> childArmsCustomSpanList) {
        this.childArmsCustomSpanList = childArmsCustomSpanList;
    }

    public boolean compareAndMerge(Object obj) {
        if (!(obj instanceof ArmsCustomSpan)) {
            return false;
        }
        ArmsCustomSpan armsCustomSpan = (ArmsCustomSpan)obj;
        if (!this.spanName.equals(armsCustomSpan.spanName)) {
            return false;
        }
        if (!armsCustomSpan.isCompressible()) {
            return false;
        }
        if (this.childArmsCustomSpanList.size() != armsCustomSpan.childArmsCustomSpanList.size()) {
            return false;
        }
        boolean hasSameSpan = true;
        if (this.childArmsCustomSpanList.size() != 0) {
            for (int i = 0; i < armsCustomSpan.childArmsCustomSpanList.size(); ++i) {
                hasSameSpan &= this.childArmsCustomSpanList.get(i).compareAndMerge(armsCustomSpan.childArmsCustomSpanList.get(i));
            }
        }
        if (hasSameSpan) {
            this.count += armsCustomSpan.count;
            this.max = Math.max(this.max, armsCustomSpan.max);
            this.min = Math.min(this.min, armsCustomSpan.min);
            this.totalDuration += armsCustomSpan.duration;
            this.sampleSpan(armsCustomSpan);
        }
        return hasSameSpan;
    }

    private void sampleSpan(ArmsCustomSpan armsCustomSpan) {
        long duration = armsCustomSpan.duration;
        StatusCode statusCode = armsCustomSpan.statusCode;
        boolean addedToTopK = false;
        if (this.topK.size() < 3) {
            this.topK.add(armsCustomSpan);
            addedToTopK = true;
        } else if (duration > this.topK.peek().duration) {
            this.topK.poll();
            this.topK.add(armsCustomSpan);
            addedToTopK = true;
        }
        if (!addedToTopK && statusCode == StatusCode.ERROR && this.errorSpan.size() < 3) {
            this.errorSpan.add(armsCustomSpan);
        }
    }
}

