/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.usermethod;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.usermethod.UserMethodAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsUserMethodState;
import java.util.logging.Level;

public final class UserMethodRpcNameHolder {
    private static final PatchLogger logger = PatchLogger.getLogger(UserMethodRpcNameHolder.class.getName());

    public static <REQUEST> ContextCustomizer<REQUEST> create(UserMethodAttributesGetter<REQUEST, ?> getter) {
        return (context, request, startAttributes) -> {
            try {
                if (ArmsUserMethodState.fromContextOrNull(context) != null) {
                    return context;
                }
                String rpcName = getter.getRpc(request);
                if (StringUtils.isBlank(rpcName)) {
                    return context;
                }
                return context.with(ArmsUserMethodState.create(rpcName));
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Failed to customize scheduled context", t);
                return context;
            }
        };
    }

    private UserMethodRpcNameHolder() {
    }
}

