/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.com.alibaba.arms.metrics.spec.UniCallKind;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.convergence.ConvergeService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.common.LocalRootSpanUpdater;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc.RpcAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.RpcMethodState;
import java.util.logging.Level;

public class RpcMethodHolder {
    private static final PatchLogger logger = PatchLogger.getLogger(RpcMethodHolder.class.getName());

    public static <REQUEST> ContextCustomizer<REQUEST> create(RpcAttributesGetter<REQUEST> getter) {
        return (context, request, startAttributes) -> {
            try {
                if (RpcMethodState.fromContextOrNull(context) != null) {
                    return context;
                }
                ConvergeService convergeService = GlobalInstanceHolder.getInstance(ConvergeService.class);
                String method = getter.getRpcName(request);
                if (convergeService != null) {
                    method = convergeService.convergeRpc(UniCallKind.RPC, method);
                }
                LocalRootSpanUpdater.updateSpanName(context, LocalRootSpan.fromContextOrNull(context), method);
                return context.with(RpcMethodState.create(method));
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Failed to customize rpc context", t);
                return context;
            }
        };
    }
}

