/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.rpc;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.AbstractArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsAttributesConvertUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsCommonServiceMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.logging.Level;

public class ArmsRpcMetrics
extends ArmsCommonServiceMetrics
implements OperationListener {
    private static final ContextKey<ArmsRpcServerMetricsState> ARMS_RPC_SERVER_METRICS_CONTEXT_KEY = ContextKey.named("arms-rpc-server-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(ArmsRpcMetrics.class.getName());

    public ArmsRpcMetrics(Meter meter) {
        super(meter);
    }

    public static OperationMetrics get() {
        return ArmsRpcMetrics::new;
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(ARMS_RPC_SERVER_METRICS_CONTEXT_KEY, new ArmsRpcServerMetricsState(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        ArmsRpcServerMetricsState state = context.get(ARMS_RPC_SERVER_METRICS_CONTEXT_KEY);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record Rpc request metrics.", context);
            return;
        }
        Attributes allAttributes = endAttributes;
        long duration = (endNanos - state.startTimeNanos) / NANOS_PER_MS;
        this.recordNormalMetrics(context, duration, ArmsAttributesConvertUtil::isSlowInterface, allAttributes);
        String callKind = allAttributes.get(ArmsConstants.AttributeKeys.ARMS_CALL_KIND_KEY);
        if (!StringUtils.isEmpty(callKind)) {
            this.recordQuantileMetrics(callKind, allAttributes, duration);
        }
    }

    static class ArmsRpcServerMetricsState
    extends AbstractArmsState {
        private final Attributes startAttributes;
        private final long startTimeNanos;

        public ArmsRpcServerMetricsState(Attributes startAttributes, long startTimeNanos) {
            this.startAttributes = startAttributes;
            this.startTimeNanos = startTimeNanos;
        }

        @Override
        public Attributes startAttributes() {
            return this.startAttributes;
        }

        @Override
        public long startTimeNanos() {
            return this.startTimeNanos;
        }
    }
}

