/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.com.alibaba.arms.metrics.spec.UniCallKind;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.convergence.ConvergeService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.common.LocalRootSpanUpdater;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging.ArmsMessagingConsumerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsMessageRpcNameState;
import java.util.logging.Level;

public final class ArmsMessageRpcNameHolder {
    private static final PatchLogger logger = PatchLogger.getLogger(ArmsMessageRpcNameHolder.class.getName());

    public static <REQUEST> ContextCustomizer<REQUEST> create(ArmsMessagingConsumerAttributesGetter<REQUEST, ?> getter) {
        return (context, request, startAttributes) -> {
            try {
                if (ArmsMessageRpcNameState.fromContextOrNull(context) != null) {
                    return context;
                }
                ConvergeService convergeService = GlobalInstanceHolder.getInstance(ConvergeService.class);
                String rpcName = getter.getRpcName(request);
                if (convergeService != null) {
                    rpcName = convergeService.convergeRpc(UniCallKind.RPC, rpcName);
                }
                LocalRootSpanUpdater.updateSpanName(context, LocalRootSpan.fromContextOrNull(context), rpcName);
                return context.with(ArmsMessageRpcNameState.create(rpcName));
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Failed to customize scheduled context", t);
                return context;
            }
        };
    }

    private ArmsMessageRpcNameHolder() {
    }
}

