/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.AbstractArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsAttributesConvertUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsCommonServiceMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.logging.Level;

public class ArmsMessageMetrics
extends ArmsCommonServiceMetrics
implements OperationListener {
    private static final ContextKey<ArmsMessageMetricsState> ARMS_MESSAGE_REQUEST_METRICS_STATE = ContextKey.named("arms-message-request-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(ArmsMessageMetrics.class.getName());

    public static OperationMetrics get() {
        return ArmsMessageMetrics::new;
    }

    private ArmsMessageMetrics(Meter meter) {
        super(meter);
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(ARMS_MESSAGE_REQUEST_METRICS_STATE, new ArmsMessageMetricsState(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        ArmsMessageMetricsState state = context.get(ARMS_MESSAGE_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record Message request metrics.", context);
            return;
        }
        Attributes allAttributes = endAttributes.toBuilder().removeIf(attribute -> ArmsConstants.AttributeKeys.MESSAGE_DELAY_MILLISECONDS_KEY.getKey().equals(attribute.getKey())).removeIf(attribute -> SemanticAttributes.MESSAGING_BATCH_MESSAGE_COUNT.getKey().equals(attribute.getKey())).putAll(state.startAttributes).build();
        long duration = (endNanos - state.startTimeNanos) / NANOS_PER_MS;
        Long count = endAttributes.get(SemanticAttributes.MESSAGING_BATCH_MESSAGE_COUNT);
        if (count != null) {
            this.recordNormalMetrics(context, duration, ArmsAttributesConvertUtil::isSlowInterface, allAttributes, count);
        } else {
            this.recordNormalMetrics(context, duration, ArmsAttributesConvertUtil::isSlowInterface, allAttributes);
        }
        String callKind = allAttributes.get(ArmsConstants.AttributeKeys.ARMS_CALL_KIND_KEY);
        if (!StringUtils.isEmpty(callKind)) {
            this.recordQuantileMetrics(callKind, allAttributes, duration);
        }
        if (endAttributes.get(ArmsConstants.AttributeKeys.MESSAGE_DELAY_MILLISECONDS_KEY) != null) {
            double value = (double)endAttributes.get(ArmsConstants.AttributeKeys.MESSAGE_DELAY_MILLISECONDS_KEY).longValue() / 1000.0;
            this.delayDuration.record(value, allAttributes, context);
        }
    }

    static class ArmsMessageMetricsState
    extends AbstractArmsState {
        private final Attributes startAttributes;
        private final long startTimeNanos;

        public ArmsMessageMetricsState(Attributes startAttributes, long startTimeNanos) {
            this.startAttributes = startAttributes;
            this.startTimeNanos = startTimeNanos;
        }

        @Override
        public Attributes startAttributes() {
            return this.startAttributes;
        }

        @Override
        public long startTimeNanos() {
            return this.startTimeNanos;
        }
    }
}

