/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsRpcConfigState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;

enum HttpStatusConverter {
    SERVER{

        @Override
        StatusCode statusFromHttpStatus(int httpStatus) {
            if (httpStatus >= 100 && httpStatus < 500) {
                return StatusCode.UNSET;
            }
            if (ArmsRpcConfigState.rpcConfigState.getSkipHttpErrorStatusSet().contains(httpStatus)) {
                return StatusCode.UNSET;
            }
            return StatusCode.ERROR;
        }
    }
    ,
    CLIENT{

        @Override
        StatusCode statusFromHttpStatus(int httpStatus) {
            if (httpStatus >= 100 && httpStatus < 400) {
                return StatusCode.UNSET;
            }
            if (ArmsRpcConfigState.rpcConfigState.getSkipHttpErrorStatusSet().contains(httpStatus)) {
                return StatusCode.UNSET;
            }
            return StatusCode.ERROR;
        }
    };


    abstract StatusCode statusFromHttpStatus(int var1);
}

