/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsOTelConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.ForwardedHeaderParser;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpNetworkTransportFilter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.InternalNetServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.FallbackAddressPortExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.network.internal.InternalServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.url.internal.InternalUrlAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HttpServerAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpServerAttributesGetter<REQUEST, RESPONSE>>
implements SpanKeyProvider {
    private static final boolean PREFER_FORWARDED_URL_SCHEME = ConfigPropertiesUtil.getBoolean("otel.instrumentation.http.prefer-forwarded-url-scheme", false);
    private final InternalUrlAttributesExtractor<REQUEST> internalUrlExtractor;
    private final InternalNetServerAttributesExtractor<REQUEST, RESPONSE> internalNetExtractor;
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final InternalServerAttributesExtractor<REQUEST, RESPONSE> internalServerExtractor;
    private final InternalClientAttributesExtractor<REQUEST, RESPONSE> internalClientExtractor;
    private final Function<Context, String> httpRouteHolderGetter;
    private final NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        return HttpServerAttributesExtractor.builder(httpAttributesGetter, netAttributesGetter).build();
    }

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        return new HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter, netAttributesGetter);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders) {
        this(httpAttributesGetter, netAttributesGetter, capturedRequestHeaders, capturedResponseHeaders, HttpRouteHolder::getRoute);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST, RESPONSE> netAttributesGetter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders, Function<Context, String> httpRouteHolderGetter) {
        super(httpAttributesGetter, capturedRequestHeaders, capturedResponseHeaders);
        HttpCommonAttributesExtractor.HttpNetAddressPortExtractor<REQUEST> addressPortExtractor = new HttpCommonAttributesExtractor.HttpNetAddressPortExtractor<REQUEST>(httpAttributesGetter);
        this.internalUrlExtractor = new InternalUrlAttributesExtractor<Object>(httpAttributesGetter, this::forwardedProto, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
        this.internalNetExtractor = new InternalNetServerAttributesExtractor<REQUEST, RESPONSE>(netAttributesGetter, addressPortExtractor, SemconvStability.emitOldHttpSemconv());
        this.internalNetworkExtractor = new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(netAttributesGetter, HttpNetworkTransportFilter.INSTANCE, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
        this.internalServerExtractor = new InternalServerAttributesExtractor<Object, RESPONSE>(netAttributesGetter, this::shouldCaptureServerPort, addressPortExtractor, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv(), InternalServerAttributesExtractor.Mode.HOST);
        this.internalClientExtractor = new InternalClientAttributesExtractor<REQUEST, RESPONSE>(netAttributesGetter, new ClientAddressAndPortExtractor(httpAttributesGetter), SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
        this.httpRouteHolderGetter = httpRouteHolderGetter;
        this.netAttributesGetter = netAttributesGetter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        if (!ArmsOTelConfigState.oTelConfigState.isoTelPerformanceEnable()) {
            super.onStart(attributes, parentContext, request);
            this.internalUrlExtractor.onStart(attributes, request);
        }
        if (ArmsOTelConfigState.oTelConfigState.isoTelAttributeEnable()) {
            this.internalNetExtractor.onStart(attributes, request);
            this.internalServerExtractor.onStart(attributes, request);
            this.internalClientExtractor.onStart(attributes, request);
        }
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_ROUTE, ((HttpServerAttributesGetter)this.getter).getHttpRoute(request));
        AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.CLIENT_ADDRESS, this.netAttributesGetter.getClientSocketAddress(request, null));
    }

    private boolean shouldCaptureServerPort(int port, REQUEST request) {
        String scheme = ((HttpServerAttributesGetter)this.getter).getUrlScheme(request);
        if (scheme == null) {
            return true;
        }
        return (!scheme.equals("http") || port != 80) && (!scheme.equals("https") || port != 443);
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Integer serverPort;
        super.onEnd(attributes, context, request, response, error);
        if (ArmsOTelConfigState.oTelConfigState.isoTelAttributeEnable()) {
            this.internalNetworkExtractor.onEnd(attributes, request, response);
            this.internalServerExtractor.onEnd(attributes, request, response);
            this.internalClientExtractor.onEnd(attributes, request, response);
        }
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_ROUTE, this.httpRouteHolderGetter.apply(context));
        StringBuilder endpoint = new StringBuilder();
        String serverAddr = this.netAttributesGetter.getServerAddress(request);
        if (StringUtils.isNotEmpty(serverAddr)) {
            endpoint.append(serverAddr);
        }
        if ((serverPort = this.netAttributesGetter.getServerPort(request)) != null) {
            endpoint.append(":").append(serverPort);
        }
        if (endpoint.length() > 0) {
            AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.ENDPOINT_KEY, endpoint.toString());
        }
    }

    @Nullable
    private String forwardedProto(REQUEST request) {
        if (!PREFER_FORWARDED_URL_SCHEME) {
            return null;
        }
        String forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).getHttpRequestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwardedHeaderParser.extractProtoFromForwardedHeader(forwarded)) != null) {
            return forwarded;
        }
        forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).getHttpRequestHeader(request, "x-forwarded-proto"));
        if (forwarded != null) {
            return ForwardedHeaderParser.extractProtoFromForwardedProtoHeader(forwarded);
        }
        return null;
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.HTTP_SERVER;
    }

    private static final class ClientAddressAndPortExtractor<REQUEST>
    implements FallbackAddressPortExtractor<REQUEST> {
        private final HttpServerAttributesGetter<REQUEST, ?> getter;

        private ClientAddressAndPortExtractor(HttpServerAttributesGetter<REQUEST, ?> getter) {
            this.getter = getter;
        }

        @Override
        public void extract(FallbackAddressPortExtractor.AddressPortSink sink, REQUEST request) {
            String forwarded = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "forwarded"));
            if (forwarded != null && (forwarded = ForwardedHeaderParser.extractClientIpFromForwardedHeader(forwarded)) != null) {
                sink.setAddress(forwarded);
                return;
            }
            forwarded = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "x-forwarded-for"));
            if (forwarded != null) {
                sink.setAddress(ForwardedHeaderParser.extractClientIpFromForwardedForHeader(forwarded));
            }
        }
    }
}

