/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai.tool;

import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.MessageCaptureOptions;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai.incubating.GenAiIncubatingAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai.incubating.GenAiToolIncubatingAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai.tool.GenAiToolAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public final class GenAiToolAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final GenAiToolAttributesGetter<REQUEST, RESPONSE> getter;
    private final MessageCaptureOptions messageCaptureOptions;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(GenAiToolAttributesGetter<REQUEST, RESPONSE> attributesGetter, MessageCaptureOptions messageCaptureOptions) {
        return new GenAiToolAttributesExtractor<REQUEST, RESPONSE>(attributesGetter, messageCaptureOptions);
    }

    private GenAiToolAttributesExtractor(GenAiToolAttributesGetter<REQUEST, RESPONSE> getter, MessageCaptureOptions messageCaptureOptions) {
        this.getter = getter;
        this.messageCaptureOptions = messageCaptureOptions;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_OPERATION_NAME, this.getter.getOperationName(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiToolIncubatingAttributes.GEN_AI_TOOL_DESCRIPTION, this.getter.getToolDescription(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiToolIncubatingAttributes.GEN_AI_TOOL_NAME, this.getter.getToolName(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiToolIncubatingAttributes.GEN_AI_TOOL_TYPE, this.getter.getToolType(request));
        if (this.messageCaptureOptions.captureMessageContent()) {
            AttributesExtractorUtil.internalSet(attributes, GenAiToolIncubatingAttributes.GEN_AI_TOOL_CALL_ARGUMENTS, this.getter.getToolCallArguments(request));
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        AttributesExtractorUtil.internalSet(attributes, GenAiToolIncubatingAttributes.GEN_AI_TOOL_CALL_ID, this.getter.getToolCallId(request, response));
        if (this.messageCaptureOptions.captureMessageContent()) {
            AttributesExtractorUtil.internalSet(attributes, GenAiToolIncubatingAttributes.GEN_AI_TOOL_CALL_RESULT, this.getter.getToolCallResult(request, response));
        }
    }
}

