/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.JsonMarshaler;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.MessageCaptureOptions;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.InputMessages;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.OutputMessages;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.SystemInstructions;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.ToolDefinitions;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai.GenAiAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai.GenAiMessagesProvider;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai.incubating.GenAiIncubatingAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.log.genai.GenAiEventLoggerProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.logs.Logger;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class GenAiMessagesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(GenAiMessagesExtractor.class.getName());
    private final MessageCaptureOptions messageCaptureOptions;
    private final GenAiAttributesGetter<REQUEST, RESPONSE> getter;
    private final GenAiMessagesProvider<REQUEST, RESPONSE> messagesProvider;
    private final String instrumentationName;
    private final AtomicBoolean lazyInit = new AtomicBoolean(false);
    private JsonMarshaler jsonMarshaler;
    private Logger eventLogger;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(GenAiAttributesGetter<REQUEST, RESPONSE> attributesGetter, GenAiMessagesProvider<REQUEST, RESPONSE> messagesProvider, MessageCaptureOptions messageCaptureOptions, String instrumentationName) {
        return new GenAiMessagesExtractor<REQUEST, RESPONSE>(attributesGetter, messagesProvider, messageCaptureOptions, instrumentationName);
    }

    private GenAiMessagesExtractor(GenAiAttributesGetter<REQUEST, RESPONSE> getter, GenAiMessagesProvider<REQUEST, RESPONSE> messagesProvider, MessageCaptureOptions messageCaptureOptions, String instrumentationName) {
        this.getter = getter;
        this.messagesProvider = messagesProvider;
        this.messageCaptureOptions = messageCaptureOptions;
        this.instrumentationName = instrumentationName;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        this.tryInit();
        if (MessageCaptureOptions.CaptureMessageStrategy.SPAN_ATTRIBUTES.equals((Object)this.messageCaptureOptions.captureMessageStrategy())) {
            ToolDefinitions toolDefinitions;
            InputMessages inputMessages;
            SystemInstructions systemInstructions = this.messagesProvider.systemInstructions(request, null);
            if (systemInstructions != null) {
                AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_SYSTEM_INSTRUCTIONS, this.toJsonString(systemInstructions.getSerializableObject()));
            }
            if ((inputMessages = this.messagesProvider.inputMessages(request, null)) != null) {
                AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_INPUT_MESSAGES, this.toJsonString(inputMessages.getSerializableObject()));
            }
            if ((toolDefinitions = this.messagesProvider.toolDefinitions(request, null)) != null) {
                AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_TOOL_DEFINITIONS, this.toJsonString(toolDefinitions.getSerializableObject()));
            }
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (MessageCaptureOptions.CaptureMessageStrategy.SPAN_ATTRIBUTES.equals((Object)this.messageCaptureOptions.captureMessageStrategy())) {
            OutputMessages outputMessages = this.messagesProvider.outputMessages(request, response);
            if (outputMessages != null) {
                AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_OUTPUT_MESSAGES, this.toJsonString(outputMessages.getSerializableObject()));
            }
        } else if (MessageCaptureOptions.CaptureMessageStrategy.EVENT.equals((Object)this.messageCaptureOptions.captureMessageStrategy())) {
            this.emitInferenceEvent(context, request, response);
        }
    }

    private void emitInferenceEvent(Context context, REQUEST request, @Nullable RESPONSE response) {
        if (this.eventLogger != null) {
            OutputMessages outputMessages;
            ToolDefinitions toolDefinitions;
            InputMessages inputMessages;
            LogRecordBuilder builder = this.eventLogger.logRecordBuilder().setAttribute(SemanticAttributes.EVENT_NAME, "gen_ai.client.inference.operation.details").setContext(context);
            SystemInstructions systemInstructions = this.messagesProvider.systemInstructions(request, response);
            if (systemInstructions != null) {
                this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_SYSTEM_INSTRUCTIONS, this.toJsonString(systemInstructions.getSerializableObject()));
            }
            if ((inputMessages = this.messagesProvider.inputMessages(request, response)) != null) {
                this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_INPUT_MESSAGES, this.toJsonString(inputMessages.getSerializableObject()));
            }
            if ((toolDefinitions = this.messagesProvider.toolDefinitions(request, null)) != null) {
                this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_TOOL_DEFINITIONS, this.toJsonString(toolDefinitions.getSerializableObject()));
            }
            if ((outputMessages = this.messagesProvider.outputMessages(request, response)) != null) {
                this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_OUTPUT_MESSAGES, this.toJsonString(outputMessages.getSerializableObject()));
            }
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_OPERATION_NAME, this.getter.getOperationName(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_OUTPUT_TYPE, this.getter.getOutputType(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_REQUEST_CHOICE_COUNT, this.getter.getChoiceCount(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_PROVIDER_NAME, this.getter.getSystem(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_REQUEST_MODEL, this.getter.getRequestModel(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_REQUEST_SEED, this.getter.getRequestSeed(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_REQUEST_FREQUENCY_PENALTY, this.getter.getRequestFrequencyPenalty(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_REQUEST_MAX_TOKENS, this.getter.getRequestMaxTokens(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_REQUEST_PRESENCE_PENALTY, this.getter.getRequestPresencePenalty(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_REQUEST_STOP_SEQUENCES, this.getter.getRequestStopSequences(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_REQUEST_TEMPERATURE, this.getter.getRequestTemperature(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_REQUEST_TOP_K, this.getter.getRequestTopK(request));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_REQUEST_TOP_P, this.getter.getRequestTopP(request));
            List<String> finishReasons = this.getter.getResponseFinishReasons(request, response);
            if (finishReasons != null && !finishReasons.isEmpty()) {
                builder.setAttribute(GenAiIncubatingAttributes.GEN_AI_RESPONSE_FINISH_REASONS, finishReasons);
            }
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_RESPONSE_ID, this.getter.getResponseId(request, response));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_RESPONSE_MODEL, this.getter.getResponseModel(request, response));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_USAGE_INPUT_TOKENS, this.getter.getUsageInputTokens(request, response));
            this.internalSetLogAttribute(builder, GenAiIncubatingAttributes.GEN_AI_USAGE_OUTPUT_TOKENS, this.getter.getUsageOutputTokens(request, response));
            builder.emit();
        }
    }

    private <T> void internalSetLogAttribute(LogRecordBuilder logRecordBuilder, AttributeKey<T> key, @Nullable T value) {
        if (value == null) {
            return;
        }
        logRecordBuilder.setAttribute(key, value);
    }

    private void tryInit() {
        if (this.lazyInit.get()) {
            return;
        }
        if (this.lazyInit.compareAndSet(false, true)) {
            GenAiEventLoggerProvider loggerProvider;
            this.jsonMarshaler = GlobalInstanceHolder.getInstance(JsonMarshaler.class);
            if (this.jsonMarshaler == null) {
                LOGGER.log(Level.WARNING, "failed to init json marshaler, global instance is null");
            }
            if ((loggerProvider = GlobalInstanceHolder.getInstance(GenAiEventLoggerProvider.class)) == null) {
                LOGGER.log(Level.WARNING, "failed to init event logger, logger provider is null");
                return;
            }
            this.eventLogger = loggerProvider.get(this.instrumentationName);
        }
    }

    private String toJsonString(Object object) {
        if (this.jsonMarshaler == null) {
            LOGGER.log(Level.INFO, "failed to serialize object, json marshaler is null");
            return null;
        }
        return this.jsonMarshaler.toJSONStringNonEmpty(object);
    }
}

