/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai.GenAiAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai.incubating.GenAiIncubatingAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.List;
import javax.annotation.Nullable;

public final class GenAiAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final GenAiAttributesGetter<REQUEST, RESPONSE> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(GenAiAttributesGetter<REQUEST, RESPONSE> attributesGetter) {
        return new GenAiAttributesExtractor<REQUEST, RESPONSE>(attributesGetter);
    }

    private GenAiAttributesExtractor(GenAiAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_OPERATION_NAME, this.getter.getOperationName(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_PROVIDER_NAME, this.getter.getSystem(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_MODEL, this.getter.getRequestModel(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_SEED, this.getter.getRequestSeed(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_ENCODING_FORMATS, this.getter.getRequestEncodingFormats(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_FREQUENCY_PENALTY, this.getter.getRequestFrequencyPenalty(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_MAX_TOKENS, this.getter.getRequestMaxTokens(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_PRESENCE_PENALTY, this.getter.getRequestPresencePenalty(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_STOP_SEQUENCES, this.getter.getRequestStopSequences(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_TEMPERATURE, this.getter.getRequestTemperature(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_TOP_K, this.getter.getRequestTopK(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_TOP_P, this.getter.getRequestTopP(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_CONVERSATION_ID, this.getter.getConversationId(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_REQUEST_CHOICE_COUNT, this.getter.getChoiceCount(request));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_OUTPUT_TYPE, this.getter.getOutputType(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        List<String> finishReasons = this.getter.getResponseFinishReasons(request, response);
        if (finishReasons != null && !finishReasons.isEmpty()) {
            attributes.put(GenAiIncubatingAttributes.GEN_AI_RESPONSE_FINISH_REASONS, finishReasons);
        }
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_RESPONSE_ID, this.getter.getResponseId(request, response));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_RESPONSE_MODEL, this.getter.getResponseModel(request, response));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_USAGE_INPUT_TOKENS, this.getter.getUsageInputTokens(request, response));
        AttributesExtractorUtil.internalSet(attributes, GenAiIncubatingAttributes.GEN_AI_USAGE_OUTPUT_TOKENS, this.getter.getUsageOutputTokens(request, response));
    }
}

