/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.MetricsRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.AbstractArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsAttributesConvertUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai.incubating.GenAiIncubatingAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ArmsGenAiMetrics
implements OperationListener,
MetricsRecorder {
    protected static final long NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final PatchLogger logger = PatchLogger.getLogger(ArmsGenAiMetrics.class.getName());
    private static final ContextKey<ArmsGenAiMetricsState> ARMS_GENAI_REQUEST_METRICS_STATE = ContextKey.named("arms-genai-request-metrics-state");
    protected final LongCounter requestCount;
    protected final DoubleHistogram requestDurationSeconds;
    protected final LongCounter slowRequestCount;
    protected final LongCounter errorRequestCount;
    protected final LongCounter usageTokens;
    protected final DoubleHistogram timeToFirstToken;

    public static OperationMetrics get() {
        return ArmsGenAiMetrics::new;
    }

    public ArmsGenAiMetrics(Meter meter) {
        this.requestCount = meter.counterBuilder("genai_calls_count").setUnit("{requests}").setDescription("The number of concurrent genai calls that are currently in-flight").build();
        this.requestDurationSeconds = meter.histogramBuilder("genai_calls_duration_seconds").setUnit("{s}").setDescription("The duration of concurrent genai calls that are currently in-flight").build();
        this.slowRequestCount = meter.counterBuilder("genai_calls_slow_count").setUnit("{requests}").setDescription("The number of concurrent slow genai calls that are currently in-flight").build();
        this.errorRequestCount = meter.counterBuilder("genai_calls_error_count").setUnit("{requests}").setDescription("The number of concurrent error genai calls that are currently in-flight").build();
        this.usageTokens = meter.counterBuilder("genai_llm_usage_tokens").setUnit("{tokens}").setDescription("The cost of usage tokens that are currently in-flight").build();
        this.timeToFirstToken = meter.histogramBuilder("genai_llm_first_token_seconds").setUnit("{s}").setDescription("The latency of first sent token that are currently in-flight").build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(ARMS_GENAI_REQUEST_METRICS_STATE, new ArmsGenAiMetricsState(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        boolean slow;
        ArmsGenAiMetricsState state = context.get(ARMS_GENAI_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record GenAi calls metrics.", context);
            return;
        }
        double duration = (double)(endNanos - state.startTimeNanos) / (double)NANOS_PER_S;
        this.requestCount.add(1L, endAttributes, context);
        this.requestDurationSeconds.record(duration, endAttributes, context);
        boolean error = ArmsAttributesConvertUtil.hasError(context, endAttributes);
        if (error) {
            this.errorRequestCount.add(1L, endAttributes, context);
        }
        if (slow = ArmsAttributesConvertUtil.isSlowInterface(duration * 1000.0)) {
            this.slowRequestCount.add(1L, endAttributes, context);
        }
    }

    @Override
    public void recordMetrics(Context context, Attributes recordAttributes, Attributes metricsAttributes) {
        Long output;
        AttributesBuilder builder = metricsAttributes.toBuilder();
        Long input = recordAttributes.get(GenAiIncubatingAttributes.GEN_AI_USAGE_INPUT_TOKENS);
        if (input != null && input > 0L) {
            this.usageTokens.add(input, builder.put(ArmsConstants.AttributeKeys.USAGE_TYPE, "input").build(), context);
        }
        if ((output = recordAttributes.get(GenAiIncubatingAttributes.GEN_AI_USAGE_OUTPUT_TOKENS)) != null && output > 0L) {
            this.usageTokens.add(output, builder.put(ArmsConstants.AttributeKeys.USAGE_TYPE, "output").build(), context);
        }
    }

    static class ArmsGenAiMetricsState
    extends AbstractArmsState {
        private final Attributes startAttributes;
        private final long startTimeNanos;

        public ArmsGenAiMetricsState(Attributes startAttributes, long startTimeNanos) {
            this.startAttributes = startAttributes;
            this.startTimeNanos = startTimeNanos;
        }

        @Override
        public Attributes startAttributes() {
            return this.startAttributes;
        }

        @Override
        public long startTimeNanos() {
            return this.startTimeNanos;
        }
    }
}

