/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.genai;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.AgentInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class ArmsGenAiAppTypeOnceOperationListener
implements OperationListener {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(ArmsGenAiAppTypeOnceOperationListener.class.getName());
    private static final String IS_LLM = "is_llm";
    private static final String GENAI_TYPE = "genai_type";
    private static final AtomicBoolean executed = new AtomicBoolean(false);
    private static final String appType = "app";

    private ArmsGenAiAppTypeOnceOperationListener() {
    }

    public static OperationListener create() {
        return new ArmsGenAiAppTypeOnceOperationListener();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context;
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        if (!executed.get()) {
            LOGGER.log(Level.INFO, "[ArmsGenAiAppTypeOnceOperationListener] try to label app as app");
            if (AgentInfo.INSTANCE.addAgentCustomArgs(IS_LLM, "1") && AgentInfo.INSTANCE.addAgentCustomArgs(GENAI_TYPE, appType) && !executed.compareAndSet(executed.get(), true)) {
                LOGGER.log(Level.INFO, "[ArmsGenAiAppTypeOnceOperationListener] failed to update executed flag");
            }
        }
    }
}

