/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsOTelConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, SqlClientAttributesGetter<REQUEST>> {
    private static final String SQL_CALL = "CALL";
    private final AttributeKey<String> dbTableAttribute;
    private final SqlStatementSanitizer sanitizer;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientAttributesExtractorBuilder(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST> getter, AttributeKey<String> dbTableAttribute, SqlStatementSanitizer sanitizer) {
        super(getter);
        this.dbTableAttribute = dbTableAttribute;
        this.sanitizer = sanitizer;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        if (ArmsOTelConfigState.oTelConfigState.isoTelAttributeEnable()) {
            SqlStatementInfo sanitizedStatement = this.sanitizer.sanitize(((SqlClientAttributesGetter)this.getter).getRawStatement(request));
            String operation = sanitizedStatement.getOperation();
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_STATEMENT, sanitizedStatement.getFullStatement());
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_OPERATION, operation);
            if (!SQL_CALL.equals(operation)) {
                AttributesExtractorUtil.internalSet(attributes, this.dbTableAttribute, sanitizedStatement.getMainIdentifier());
            }
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context parentContext, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, parentContext, request, response, error);
        SqlStatementInfo sanitizedStatement = ((SqlClientAttributesGetter)this.getter).getStatementInfo(request);
        if (sanitizedStatement == null) {
            sanitizedStatement = this.sanitizer.sanitize(((SqlClientAttributesGetter)this.getter).getSql(request));
        }
        String operation = sanitizedStatement.getOperation();
        AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.OP_TYPE_KEY, operation);
        if (!SQL_CALL.equals(operation)) {
            AttributesExtractorUtil.internalSet(attributes, AttributeKey.stringKey("tableName"), sanitizedStatement.getMainIdentifier());
        }
    }
}

