/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Callback;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.ConfigKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Endpoint(value=ConfigEnum.ARMS_APP_CONFIG_ENDPOINT)
@DataId(value=ConfigEnum.ARMS_APP_CONFIG_DATA_ID)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
@Namespace(value=ConfigEnum.ARMS_APP_CONFIG_NAMESPACE)
public class SpanUpdaterState
extends ArmsState {
    @ConfigKey(value="profiler.sampling.v2config.enableSkipSampleRpcType", type=String.class)
    private volatile String enableSkipSampleRpcTypeStr = "";
    private final Set<Integer> configuredSkipSampleRpcType = ConcurrentHashMap.newKeySet();
    private volatile boolean hasValidConfig = false;
    private static final SpanUpdaterState instance = new SpanUpdaterState();

    public static SpanUpdaterState getInstance() {
        return instance;
    }

    @Callback
    public void onConfigChanged(String configInfo) {
        this.configuredSkipSampleRpcType.clear();
        Arrays.stream(this.enableSkipSampleRpcTypeStr.split(",")).forEach(str -> this.configuredSkipSampleRpcType.add(Integer.valueOf(str)));
        this.hasValidConfig = this.configuredSkipSampleRpcType.size() > 0;
    }

    public boolean shouldSkipSampleWhenSpanCreating(int rpcType) {
        return rpcType == 0 || this.hasValidConfig && this.configuredSkipSampleRpcType.contains(rpcType);
    }

    public void setEnableSkipSampleRpcTypeStr(String enableSkipSampleRpcTypeStr) {
        this.enableSkipSampleRpcTypeStr = enableSkipSampleRpcTypeStr;
    }
}

