/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.common;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class RpcUpdateListener {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(RpcUpdateListener.class.getName());
    private static final ContextKey<List<BiConsumer<Context, String>>> KEY = ContextKey.named("arms-traces-rpc-update-listeners");

    public static List<BiConsumer<Context, String>> current() {
        return RpcUpdateListener.fromContext(Context.current());
    }

    public static List<BiConsumer<Context, String>> fromContext(Context context) {
        List<BiConsumer<Context, String>> listeners = RpcUpdateListener.fromContextOrNull(context);
        return listeners == null ? Collections.emptyList() : listeners;
    }

    @Nullable
    public static List<BiConsumer<Context, String>> fromContextOrNull(Context context) {
        return context.get(KEY);
    }

    public static Context store(Context context, List<BiConsumer<Context, String>> listeners) {
        return context.with(KEY, listeners);
    }

    public static Context append(Context context, BiConsumer<Context, String> listener) {
        List<BiConsumer<Context, String>> listeners = RpcUpdateListener.fromContextOrNull(context);
        if (listeners == null) {
            listeners = new ArrayList<BiConsumer<Context, String>>();
        }
        listeners.add(listener);
        return context.with(KEY, listeners);
    }

    public static void onUpdate(Context context, String newRpc) {
        if ("/*".equals(newRpc)) {
            return;
        }
        List<BiConsumer<Context, String>> listeners = RpcUpdateListener.fromContext(context);
        for (BiConsumer<Context, String> listener : listeners) {
            try {
                listener.accept(context, newRpc);
            }
            catch (Throwable e) {
                LOGGER.log(Level.INFO, "Failed to trigger listener, cause: " + e.getMessage());
            }
        }
    }

    public static void onRequestBodyChanged(Context context, String rpc) {
        List<BiConsumer<Context, String>> listeners = RpcUpdateListener.fromContext(context);
        for (BiConsumer<Context, String> listener : listeners) {
            try {
                listener.accept(context, rpc);
            }
            catch (Throwable e) {
                LOGGER.log(Level.INFO, "Failed to trigger listener, cause: " + e.getMessage());
            }
        }
    }
}

