/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.sample.SpanSampleFlagUpdater;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AliyunContextHolderUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.SpanUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.profiling.HotSpotRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsRpcConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.common.RpcUpdateListener;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;

public class LocalRootSpanUpdater {
    private static final AliyunJavaAgentLogger LOGGER = AliyunJavaAgentLoggerFactory.getLogger(LocalRootSpanUpdater.class.getName());
    private static SpanSampleFlagUpdater sampleFlagUpdater;

    public static void updateSpanName(Context context, Span span, String newSpanName) {
        if (span == null) {
            return;
        }
        span.updateName(newSpanName);
        LocalRootSpanUpdater.updateSpanSampleFlag(newSpanName, span);
        try {
            HotSpotRecorder.attach(context);
        }
        catch (Throwable t) {
            LOGGER.debug("[CP] LocalRootSpanUpdater execute attach failed, t" + t);
        }
        RpcUpdateListener.onUpdate(context, newSpanName);
    }

    public static void updateSpanSampleFlag(String name, Span span) {
        Boolean sampleLater;
        Boolean skipByHttpMethod = (Boolean)AliyunContextHolderUtils.getFromAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_HTTP_METHOD_KEY.getKey(), Context.current());
        if (ArmsRpcConfigState.rpcConfigState.shouldIgnore(name) || skipByHttpMethod != null && skipByHttpMethod.booleanValue()) {
            SpanUtils.updateSampleFlag(span, TraceFlags.getDefault());
            AliyunContextHolderUtils.putToAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_RPC_KEY.getKey(), true, Context.current());
            return;
        }
        Boolean skipMetric = (Boolean)AliyunContextHolderUtils.getFromAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_RPC_KEY.getKey(), Context.current());
        if (skipMetric != null && skipMetric.booleanValue()) {
            AliyunContextHolderUtils.putToAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_RPC_KEY.getKey(), false, Context.current());
        }
        if ((sampleLater = SpanUtils.getAttribute(ArmsConstants.AttributeKeys.SAMPLER_LATER_KEY, span)) != null && sampleLater.booleanValue()) {
            if (sampleFlagUpdater == null) {
                sampleFlagUpdater = GlobalInstanceHolder.getInstance(SpanSampleFlagUpdater.class);
            }
            sampleFlagUpdater.updateSpanSampleFlag(name, span);
        }
    }
}

