/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.test;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ArmsTestInstrumenters {
    private final Instrumenter<String, Void> instrumenter;
    private final Instrumenter<String, Void> httpClientInstrumenter;
    private final Instrumenter<String, Void> httpServerInstrumenter;

    public ArmsTestInstrumenters() {
        OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
        this.instrumenter = Instrumenter.builder(openTelemetry, "test", name -> name).buildInstrumenter(SpanKindExtractor.alwaysInternal());
        this.httpClientInstrumenter = Instrumenter.builder(openTelemetry, "test", name -> name).addAttributesExtractor(new SpanKeyAttributesExtractor(SpanKey.HTTP_CLIENT)).addAttributesExtractor(new SpanKeyAttributesExtractor(SpanKey.KIND_CLIENT)).buildInstrumenter(SpanKindExtractor.alwaysClient());
        this.httpServerInstrumenter = Instrumenter.builder(openTelemetry, "test", HttpSpanNameExtractor.create(HttpServerGetter.INSTANCE)).addAttributesExtractor(HttpServerAttributesExtractor.create(HttpServerGetter.INSTANCE, NetServerGetter.INSTANCE)).addAttributesExtractor(new SpanKeyAttributesExtractor(SpanKey.KIND_SERVER)).addContextCustomizer(HttpRouteHolder.create(HttpServerGetter.INSTANCE)).buildInstrumenter(SpanKindExtractor.alwaysServer());
    }

    public <T, E extends Throwable> T runWithSpan(String spanName, Object callback) throws Throwable {
        return ArmsTestInstrumenters.runWithInstrumenter(spanName, this.instrumenter, callback);
    }

    public <T, E extends Throwable> T runWithHttpClientSpan(String spanName, Object callback) throws Throwable {
        return ArmsTestInstrumenters.runWithInstrumenter(spanName, this.httpClientInstrumenter, callback);
    }

    public <T, E extends Throwable> T runWithHttpServerSpan(Object callback) throws Throwable {
        return ArmsTestInstrumenters.runWithInstrumenter("ignored", this.httpServerInstrumenter, callback);
    }

    public <T, E extends Throwable> T runWithNonRecordingSpan(Object callback) throws Throwable {
        SpanContext spanContext = SpanContext.create("12345678123456781234567812345678", "1234567812345678", TraceFlags.getDefault(), TraceState.getDefault());
        try (Scope ignored = Span.wrap(spanContext).makeCurrent();){
            Object object = ArmsTestInstrumenters.callbackGet(callback);
            return (T)object;
        }
    }

    private static <T, E extends Throwable> T runWithInstrumenter(String spanName, Instrumenter<String, Void> instrumenter, Object callback) throws Throwable {
        Context context = instrumenter.start(Context.current(), spanName);
        Throwable err = null;
        try {
            Object object;
            block11: {
                Scope ignored = context.makeCurrent();
                try {
                    object = ArmsTestInstrumenters.callbackGet(callback);
                    if (ignored == null) break block11;
                    ignored.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        err = t;
                        throw t;
                    }
                }
            }
            return (T)object;
        }
        finally {
            instrumenter.end(context, spanName, null, err);
        }
    }

    private static Object callbackGet(Object callback) throws Throwable {
        try {
            Method get = callback.getClass().getDeclaredMethod("get", new Class[0]);
            get.setAccessible(true);
            return get.invoke(callback, new Object[0]);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                throw t.getCause();
            }
            throw new RuntimeException(t);
        }
    }

    private static final class SpanKeyAttributesExtractor
    implements AttributesExtractor<String, Void>,
    SpanKeyProvider {
        private final SpanKey spanKey;

        private SpanKeyAttributesExtractor(SpanKey spanKey) {
            this.spanKey = spanKey;
        }

        @Override
        public void onStart(AttributesBuilder attributes, Context parentContext, String s) {
        }

        @Override
        public void onEnd(AttributesBuilder attributes, Context context, String s, @Nullable Void unused, @Nullable Throwable error) {
        }

        @Override
        public SpanKey internalGetSpanKey() {
            return this.spanKey;
        }
    }

    private static enum HttpServerGetter implements HttpServerAttributesGetter<String, Void>
    {
        INSTANCE;


        @Override
        public String getHttpRequestMethod(String unused) {
            return "GET";
        }

        @Override
        public List<String> getHttpRequestHeader(String unused, String name) {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public Integer getHttpResponseStatusCode(String unused, Void unused2, @Nullable Throwable error) {
            return null;
        }

        @Override
        public List<String> getHttpResponseHeader(String unused, Void unused2, String name) {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public String getUrlScheme(String unused) {
            return null;
        }

        @Override
        @Nullable
        public String getUrlPath(String s) {
            return null;
        }

        @Override
        @Nullable
        public String getUrlQuery(String s) {
            return null;
        }
    }

    private static enum NetServerGetter implements NetServerAttributesGetter<String, Void>
    {
        INSTANCE;


        @Override
        @Nullable
        public String getServerAddress(String unused) {
            return null;
        }

        @Override
        @Nullable
        public Integer getServerPort(String unused) {
            return null;
        }
    }
}

