/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SelfMonitorMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.biz_trace.BusinessTraceRecord;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.CustomExtractRecord;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.ExtractRule;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.enums.ExtractSourceEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.enums.ExtractTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract.AbstractCustomParamExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract.HttpServerCustomParamExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.common.RpcUpdateListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import javax.annotation.Nullable;

public final class HttpServerCustomParamExtractor<REQUEST, RESPONSE>
extends AbstractCustomParamExtractor<REQUEST, RESPONSE> {
    private static final PatchLogger logger = PatchLogger.getLogger(HttpServerCustomParamExtractor.class.getName());
    private final SpanReader spanReader;
    HttpServerAttributesGetter<REQUEST, RESPONSE> getter;

    HttpServerCustomParamExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
        this.spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
        if (this.spanReader == null) {
            logger.log(Level.SEVERE, "SpanReader is null, please check the configuration");
        }
    }

    public static <REQUEST, RESPONSE> HttpServerCustomParamExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return new HttpServerCustomParamExtractorBuilder<REQUEST, RESPONSE>(getter);
    }

    public static <REQUEST, RESPONSE> HttpServerCustomParamExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return HttpServerCustomParamExtractor.builder(getter).build();
    }

    @Override
    public Context onStart(Context parentContext, REQUEST request) {
        Span span = LocalRootSpan.fromContextOrNull(parentContext);
        if (span == null || this.spanReader == null || this.getBusinessObservabilityService() == null) {
            return parentContext;
        }
        String rpcName = this.spanReader.readSpanName(span);
        BiConsumer<Context, String> listener = (ctx, rpc) -> {
            Map<String, CustomExtractRecord> requestRecords = this.getBusinessObservabilityService().getMatchedExtractRecord((String)rpc, ExtractTypeEnum.HTTP_REQUEST_SERVER);
            this.doExtractForHttpServer((Context)ctx, request, null, requestRecords, ExtractTypeEnum.HTTP_REQUEST_SERVER);
        };
        listener.accept(parentContext, rpcName);
        return RpcUpdateListener.append(parentContext, listener);
    }

    @Override
    public void onEnd(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Span span = LocalRootSpan.fromContextOrNull(context);
        if (span == null || this.spanReader == null || this.getBusinessObservabilityService() == null) {
            return;
        }
        String rpcName = this.spanReader.readSpanName(span);
        if (this.getBusinessObservabilityService().isCustomExtractEnable()) {
            if (response == null) {
                logger.log(Level.INFO, "Unable to extract parameters from empty response");
            } else {
                Map<String, CustomExtractRecord> responseRecords = this.getBusinessObservabilityService().getMatchedExtractRecord(rpcName, ExtractTypeEnum.HTTP_RESPONSE_SERVER);
                this.doExtractForHttpServer(context, request, response, responseRecords, ExtractTypeEnum.HTTP_RESPONSE_SERVER);
            }
        }
        if (this.getBusinessObservabilityService().isBizO11yEnable()) {
            Map<String, BusinessTraceRecord> records = this.getBusinessObservabilityService().getBusinessTraceRecordWithCurrentBizCode(context);
            this.doExtractInputAndOutputOfHttpServer(context, request, response, records);
        }
    }

    private void doExtractForHttpServer(Context context, REQUEST request, @Nullable RESPONSE response, Map<String, CustomExtractRecord> recordMap, ExtractTypeEnum type) {
        for (Map.Entry<String, CustomExtractRecord> entry : recordMap.entrySet()) {
            String attributeKey = entry.getKey();
            CustomExtractRecord record = entry.getValue();
            List<ExtractRule> orderedExtractRules = record.getOrderedExtractRules();
            String attributeValue = null;
            for (ExtractRule rule : orderedExtractRules) {
                Object carrier = this.adaptedGetParamCarrier(context, request, response, rule.getSource(), rule.getCarrierKey(), type, record.getRecordId());
                if (carrier == null) {
                    logger.log(Level.INFO, "[" + record.getRecordId() + "]Carrier key is null, cannot get carrier from " + rule.getSource().name());
                    continue;
                }
                attributeValue = rule.doExtract(carrier);
                if (attributeValue == null || attributeValue.isEmpty()) continue;
                SelfMonitorMetrics.increaseCustomExtractCount(record.getRecordId(), "HIT", record.getExtractType().name(), rule.getSource().name(), 1);
                logger.log(Level.INFO, "[" + record.getRecordId() + "] Get attribute of key [" + attributeKey + "] by rule [" + rule.getSource().name() + "]");
                break;
            }
            if (attributeValue == null || attributeValue.isEmpty()) {
                SelfMonitorMetrics.increaseCustomExtractCount(record.getRecordId(), "MISS", record.getExtractType().name(), null, 1);
                logger.log(Level.INFO, "[" + record.getRecordId() + "] Cannot get attribute of key [" + attributeKey + "]");
                continue;
            }
            this.getBusinessObservabilityService().cacheIncomeAttributes(context, record, attributeKey, attributeValue);
        }
    }

    void doExtractInputAndOutputOfHttpServer(Context context, REQUEST request, @Nullable RESPONSE response, Map<String, BusinessTraceRecord> recordMap) {
        AttributeKey<String> attributeKey;
        String result;
        Object rawCarrier;
        int inputRulesFlag = 0;
        int outputRulesFlag = 0;
        ExtractRule[] mergedInputRules = null;
        ExtractRule[] mergedOutputRules = null;
        int iter = 0;
        for (Map.Entry<String, BusinessTraceRecord> entry : recordMap.entrySet()) {
            BusinessTraceRecord record = entry.getValue();
            inputRulesFlag |= record.getInputExtractRulesFlag();
            outputRulesFlag |= record.getOutputExtractRulesFlag();
            if (++iter != recordMap.size()) continue;
            mergedInputRules = record.getExtractRulesByFlag(inputRulesFlag);
            mergedOutputRules = record.getExtractRulesByFlag(outputRulesFlag);
        }
        AttributesBuilder attrBuilder = Attributes.builder();
        if (mergedInputRules != null) {
            for (void var14_16 : mergedInputRules) {
                rawCarrier = this.adaptedGetParamCarrier(context, request, response, var14_16.getSource(), null, ExtractTypeEnum.HTTP_REQUEST_SERVER, "biz_trace");
                result = var14_16.doExtract(rawCarrier);
                attributeKey = this.decideAttributeKey(var14_16.getSource(), ExtractTypeEnum.HTTP_REQUEST_SERVER);
                if (attributeKey != null) {
                    attrBuilder.put(attributeKey, result);
                    continue;
                }
                logger.log(Level.INFO, "[biz_trace] Cannot get attribute key, source: [" + var14_16.getSource().name() + "], type: [" + ExtractTypeEnum.HTTP_REQUEST_SERVER.name() + "]");
            }
        }
        if (response != null && mergedOutputRules != null) {
            for (void var14_18 : mergedOutputRules) {
                rawCarrier = this.adaptedGetParamCarrier(context, request, response, var14_18.getSource(), null, ExtractTypeEnum.HTTP_RESPONSE_SERVER, "biz_trace");
                result = var14_18.doExtract(rawCarrier);
                attributeKey = this.decideAttributeKey(var14_18.getSource(), ExtractTypeEnum.HTTP_RESPONSE_SERVER);
                if (attributeKey != null) {
                    attrBuilder.put(attributeKey, result);
                    continue;
                }
                logger.log(Level.INFO, "[biz_trace] Cannot get attribute key, source: [" + var14_18.getSource().name() + "], type: [" + ExtractTypeEnum.HTTP_RESPONSE_SERVER.name() + "]");
            }
        }
        this.getBusinessObservabilityService().cacheIOAttributes(context, attrBuilder.build());
    }

    private Object adaptedGetParamCarrier(Context context, REQUEST request, @Nullable RESPONSE response, ExtractSourceEnum source, String carrierKey, ExtractTypeEnum type, String recordId) {
        if (!source.isSupported(type)) {
            logger.log(Level.INFO, "[" + recordId + "] Unsupported source " + source.name() + " of type " + type.name());
            return null;
        }
        if (ExtractSourceEnum.PARAMETER.equals((Object)source)) {
            if (carrierKey == null || carrierKey.isEmpty()) {
                return this.getter.getAllHttpRequestParams(request);
            }
            Object[] values = this.getter.getHttpRequestParams(request, carrierKey);
            if (values == null || values.length == 0) {
                return null;
            }
            if (values.length == 1) {
                return values[0];
            }
            return StringUtils.arrayToString(values);
        }
        if (ExtractSourceEnum.COOKIE.equals((Object)source)) {
            Map<String, String> cookies = null;
            if (carrierKey == null || carrierKey.isEmpty()) {
                return null;
            }
            if (ExtractTypeEnum.HTTP_REQUEST_SERVER.equals((Object)type)) {
                cookies = this.getter.getHttpRequestCookies(request, Collections.singleton(carrierKey));
            } else if (ExtractTypeEnum.HTTP_RESPONSE_SERVER.equals((Object)type)) {
                cookies = this.getter.getHttpResponseCookies(request, response, Collections.singleton(carrierKey));
            }
            if (cookies == null || cookies.isEmpty()) {
                return null;
            }
            String value = cookies.get(carrierKey);
            return value.isEmpty() ? null : value;
        }
        if (ExtractSourceEnum.HEADER.equals((Object)source)) {
            if (carrierKey == null || carrierKey.isEmpty()) {
                String headerMap = null;
                if (ExtractTypeEnum.HTTP_REQUEST_SERVER.equals((Object)type)) {
                    headerMap = this.getter.getAllHttpRequestHeaders(request);
                } else if (ExtractTypeEnum.HTTP_RESPONSE_SERVER.equals((Object)type)) {
                    headerMap = this.getter.getAllHttpResponseHeaders(request, response);
                }
                return StringUtils.objectToString(headerMap);
            }
            List<String> headers = null;
            if (ExtractTypeEnum.HTTP_REQUEST_SERVER.equals((Object)type)) {
                headers = this.getter.getHttpRequestHeader(request, carrierKey);
            } else if (ExtractTypeEnum.HTTP_RESPONSE_SERVER.equals((Object)type)) {
                headers = this.getter.getHttpResponseHeader(request, response, carrierKey);
            }
            if (headers == null || headers.isEmpty()) {
                return null;
            }
            if (headers.size() == 1) {
                return headers.get(0);
            }
            return StringUtils.listToString(headers);
        }
        if (ExtractSourceEnum.BODY.equals((Object)source)) {
            return this.getBusinessObservabilityService().getIncomeCarrier(context, type, source);
        }
        logger.log(Level.INFO, "[" + recordId + "] Unsupported source " + source.name() + " of type " + type.name());
        return null;
    }

    @Nullable
    private AttributeKey<String> decideAttributeKey(ExtractSourceEnum source, ExtractTypeEnum type) {
        if (source == null || source == ExtractSourceEnum.UNKNOWN) {
            return null;
        }
        if (!source.isSupported(type)) {
            return null;
        }
        if (type == ExtractTypeEnum.HTTP_REQUEST_SERVER) {
            if (source == ExtractSourceEnum.PARAMETER) {
                return ArmsConstants.AttributeKeys.ARMS_BIZ_REQ_PARAM;
            }
            if (source == ExtractSourceEnum.HEADER) {
                return ArmsConstants.AttributeKeys.ARMS_BIZ_REQ_HEADER;
            }
            if (source == ExtractSourceEnum.BODY) {
                return ArmsConstants.AttributeKeys.ARMS_BIZ_REQ_BODY;
            }
        } else if (type == ExtractTypeEnum.HTTP_RESPONSE_SERVER) {
            if (source == ExtractSourceEnum.HEADER) {
                return ArmsConstants.AttributeKeys.ARMS_BIZ_RESP_HEADER;
            }
            if (source == ExtractSourceEnum.BODY) {
                return ArmsConstants.AttributeKeys.ARMS_BIZ_RESP_BODY;
            }
        }
        return null;
    }
}

