/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SelfMonitorMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.CustomExtractRecord;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.ExtractRule;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.enums.ExtractSourceEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.enums.ExtractTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract.AbstractCustomParamExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.extract.HttpClientCustomParamExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;

public final class HttpClientCustomParamExtractor<REQUEST, RESPONSE>
extends AbstractCustomParamExtractor<REQUEST, RESPONSE> {
    private static final PatchLogger logger = PatchLogger.getLogger(HttpClientCustomParamExtractor.class.getName());
    private final SpanReader spanReader;
    HttpClientAttributesGetter<REQUEST, RESPONSE> getter;

    HttpClientCustomParamExtractor(HttpClientAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
        this.spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
        if (this.spanReader == null) {
            logger.log(Level.SEVERE, "SpanReader is null, please check the configuration");
        }
    }

    public static <REQUEST, RESPONSE> HttpClientCustomParamExtractorBuilder<REQUEST, RESPONSE> builder(HttpClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new HttpClientCustomParamExtractorBuilder<REQUEST, RESPONSE>(getter);
    }

    public static <REQUEST, RESPONSE> HttpClientCustomParamExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return HttpClientCustomParamExtractor.builder(getter).build();
    }

    @Override
    public Context onStart(Context context, REQUEST request) {
        Span span = Span.fromContext(context);
        if (span == null || this.spanReader == null || this.getBusinessObservabilityService() == null) {
            return context;
        }
        String rpcName = this.spanReader.readSpanName(span);
        String spanId = span.getSpanContext().getSpanId();
        Map<String, CustomExtractRecord> requestRecords = this.getBusinessObservabilityService().getMatchedExtractRecord(rpcName, ExtractTypeEnum.HTTP_REQUEST_CLIENT);
        this.doExtractForHttpClient(context, request, null, requestRecords, ExtractTypeEnum.HTTP_REQUEST_CLIENT, spanId);
        return context;
    }

    @Override
    public void onEnd(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Span span = Span.fromContext(context);
        if (span == null || this.spanReader == null || this.getBusinessObservabilityService() == null) {
            return;
        }
        String rpcName = this.spanReader.readSpanName(span);
        String spanId = span.getSpanContext().getSpanId();
        if (response == null) {
            logger.log(Level.INFO, "Unable to extract parameters from empty response");
        } else {
            Map<String, CustomExtractRecord> responseRecords = this.getBusinessObservabilityService().getMatchedExtractRecord(rpcName, ExtractTypeEnum.HTTP_RESPONSE_CLIENT);
            this.doExtractForHttpClient(context, request, response, responseRecords, ExtractTypeEnum.HTTP_RESPONSE_CLIENT, spanId);
        }
    }

    private void doExtractForHttpClient(Context context, REQUEST request, @Nullable RESPONSE response, Map<String, CustomExtractRecord> recordMap, ExtractTypeEnum type, String spanId) {
        for (Map.Entry<String, CustomExtractRecord> entry : recordMap.entrySet()) {
            String attributeKey = entry.getKey();
            CustomExtractRecord record = entry.getValue();
            List<ExtractRule> orderedExtractRules = record.getOrderedExtractRules();
            String attributeValue = null;
            for (ExtractRule rule : orderedExtractRules) {
                Object carrier = this.adaptedGetParamCarrier(context, request, response, rule, type, record.getRecordId());
                if (carrier == null) {
                    logger.log(Level.INFO, "[" + record.getRecordId() + "]Carrier key is null, cannot get carrier from " + rule.getSource().name());
                    continue;
                }
                attributeValue = rule.doExtract(carrier);
                if (attributeValue == null || attributeValue.isEmpty()) continue;
                SelfMonitorMetrics.increaseCustomExtractCount(record.getRecordId(), "HIT", record.getExtractType().name(), rule.getSource().name(), 1);
                logger.log(Level.INFO, "[" + record.getRecordId() + "] Get attribute of key [" + attributeKey + "] by rule [" + rule.getSource().name() + "]");
                break;
            }
            if (attributeValue == null || attributeValue.isEmpty()) {
                SelfMonitorMetrics.increaseCustomExtractCount(record.getRecordId(), "MISS", record.getExtractType().name(), null, 1);
                logger.log(Level.INFO, "[" + record.getRecordId() + "] Cannot get attribute of key [" + attributeKey + "]");
                continue;
            }
            this.getBusinessObservabilityService().cacheNormalAttributes(context, spanId, record, attributeKey, attributeValue);
        }
    }

    private Object adaptedGetParamCarrier(Context context, REQUEST request, @Nullable RESPONSE response, ExtractRule rule, ExtractTypeEnum type, String recordId) {
        ExtractSourceEnum source = rule.getSource();
        if (!source.isSupported(type)) {
            logger.log(Level.INFO, "[" + recordId + "] Unsupported source " + source.name() + " of type " + type.name());
            return null;
        }
        String carrierKey = rule.getCarrierKey();
        if (ExtractSourceEnum.PARAMETER.equals((Object)source)) {
            Map<String, List<String>> params = null;
            if (carrierKey == null || carrierKey.isEmpty()) {
                return null;
            }
            params = this.getter.getHttpRequestParams(request, Collections.singletonList(carrierKey));
            if (params == null || params.isEmpty()) {
                return null;
            }
            List values = params.getOrDefault(carrierKey, null);
            if (values == null || values.size() == 0) {
                return null;
            }
            if (values.size() == 1) {
                return values.get(0);
            }
            return StringUtils.listToString(values);
        }
        if (ExtractSourceEnum.HEADER.equals((Object)source)) {
            List<String> headers = null;
            if (carrierKey == null || carrierKey.isEmpty()) {
                return null;
            }
            if (ExtractTypeEnum.HTTP_REQUEST_CLIENT.equals((Object)type)) {
                headers = this.getter.getHttpRequestHeader(request, carrierKey);
            } else if (ExtractTypeEnum.HTTP_RESPONSE_CLIENT.equals((Object)type)) {
                headers = this.getter.getHttpResponseHeader(request, response, carrierKey);
            }
            if (headers == null || headers.isEmpty()) {
                return null;
            }
            if (headers.size() == 1) {
                return headers.get(0);
            }
            return StringUtils.listToString(headers);
        }
        logger.log(Level.INFO, "[" + recordId + "] Unsupported source " + source.name() + " of type " + type.name());
        return null;
    }
}

