/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.PathMatcher;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AntPathMatcher;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Callback;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.ConfigKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsAttributesConvertUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.SpanInterfaceMatcher;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.NumberUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@Endpoint(value=ConfigEnum.ARMS_APP_CONFIG_ENDPOINT)
@DataId(value=ConfigEnum.ARMS_APP_CONFIG_DATA_ID)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
@Namespace(value=ConfigEnum.ARMS_APP_CONFIG_NAMESPACE)
public class ArmsRpcConfigState
extends ArmsState {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(ArmsAttributesConvertUtil.class.getName());
    @ConfigKey(value="profiler.thresholds.interface", type=Integer.class)
    private volatile int interfaceThreshold = 500;
    @ConfigKey(value="profiler.error.skip", type=String.class)
    private volatile String skipHttpErrorStatus;
    @ConfigKey(value="profiler.param.maxLength", type=Integer.class)
    private volatile int paramMaxLength = 512;
    @ConfigKey(value="profiler.defined.excludeurl", type=String.class)
    private volatile String ignoreUrl = "/**/*.jpg,/**/*.png,/**/*.js,/**/*.jpeg,/**/*.pdf,/**/*.xlsx,/**/*.txt,/**/*.docs,/**/*.gif,/**/*.csv,/**/*.log,/**/*.7z,/**/*.tgz,/**/*.css,/**/*.ico,/**/*.woff2,/**/*.xml,/**/*.svg,/**/*.text,/**/*.ppt,/**/*.word,/**/*.tar.gz,/**/*.tar.bz2,/**/*.sh,/**/*.yml,/**/*.yaml,/**/*.zip,/**/*.gz,/**/*.ttf,/**/*.woff,/**/*.eot,/**/*.rar,/**/*.properties";
    @ConfigKey(value="profiler.http.metrics.recordHttpCode", type=Boolean.class)
    private volatile Boolean recordOriginalHttpCodeInMetrics = false;
    @ConfigKey(value="profiler.http.ignore.methods", type=String.class)
    private volatile String ignoreHttpMethod = "OPTIONS,TRACE,CONNECT";
    @ConfigKey(value="apsara.apm.instrumentation.common.http_server.contain_method_in_span_name")
    private volatile boolean containsMethodInSpanName = ConfigPropertiesUtil.getBoolean("apsara.apm.instrumentation.common.http_server.contain_method_in_span_name", false);
    private PathMatcher matcher;
    private volatile Set<Integer> skipHttpErrorStatusSet = new HashSet<Integer>();
    private volatile Set<String> matchUrlSet = new HashSet<String>();
    private volatile Set<String> equalsUrlSet = new HashSet<String>();
    private volatile Set<String> endsWithUrlSet = new HashSet<String>();
    private volatile Set<String> equalsRpcSet = new HashSet<String>();
    private Set<String> defaultUrlSet = new HashSet<String>(Arrays.asList(".gif", ".pdf", ".txt", ".jpg", ".js", ".xlsx", ".jpeg", ".png", ".docs", ".csv"));
    public static ArmsRpcConfigState rpcConfigState = new ArmsRpcConfigState();

    public ArmsRpcConfigState() {
        try {
            this.matcher = new AntPathMatcher();
        }
        catch (Throwable t) {
            logger.warn("Failed to init ant path matcher", t);
        }
        super.registerConfigInstance(this);
    }

    @Override
    @Callback
    public void callback(String configInfo) {
        logger.info("[ArmsThresholdState] configInfo update.");
        HashSet<Integer> localSkipHttpErrorStatusSet = new HashSet<Integer>();
        HashSet<String> localEndWithSet = new HashSet<String>();
        HashSet<String> localMatchUrlSet = new HashSet<String>();
        HashSet<String> localEqualsUrlSet = new HashSet<String>();
        HashSet<String> localEqualsRpcSet = new HashSet<String>();
        if (!StringUtils.isNullOrEmpty(this.skipHttpErrorStatus)) {
            try {
                for (String code : this.skipHttpErrorStatus.split(",")) {
                    localSkipHttpErrorStatusSet.add(NumberUtils.parseInteger(code, 0));
                }
            }
            catch (Exception e) {
                logger.warn("getSkipErrorHttpStatus error,{}", (Object)this.skipHttpErrorStatus, (Object)e);
            }
        }
        SpanInterfaceMatcher.INSTANCE.reset();
        if (!StringUtils.isNullOrEmpty(this.ignoreUrl)) {
            for (String filterPath : this.ignoreUrl.split(",")) {
                try {
                    filterPath = filterPath.trim();
                    localEqualsRpcSet.add(filterPath);
                    if (filterPath.startsWith("/**/*") && filterPath.length() > 5) {
                        String path = filterPath.substring(5);
                        localEndWithSet.add(path);
                        if (this.defaultUrlSet.contains(path)) continue;
                        SpanInterfaceMatcher.INSTANCE.addCustomEndWithUrls(path);
                        continue;
                    }
                    if (!"/**".equals(filterPath) && !filterPath.startsWith("{ARMS") && this.matcher.isPattern(filterPath)) {
                        localMatchUrlSet.add(filterPath);
                        SpanInterfaceMatcher.INSTANCE.addCustomMatchUrls(filterPath);
                        continue;
                    }
                    localEqualsUrlSet.add(filterPath);
                    SpanInterfaceMatcher.INSTANCE.addCustomEqualsUrls(filterPath);
                }
                catch (Exception e) {
                    logger.warn("ignoreUrlSet error,{}", (Object)this.ignoreUrl, (Object)e);
                }
            }
        }
        this.skipHttpErrorStatusSet = localSkipHttpErrorStatusSet;
        this.endsWithUrlSet = localEndWithSet;
        this.matchUrlSet = localMatchUrlSet;
        this.equalsUrlSet = localEqualsUrlSet;
        this.equalsRpcSet = localEqualsRpcSet;
    }

    public Set<Integer> getSkipHttpErrorStatusSet() {
        return this.skipHttpErrorStatusSet;
    }

    public int getInterfaceThreshold() {
        return this.interfaceThreshold;
    }

    public int getParamMaxLength() {
        return this.paramMaxLength;
    }

    public Boolean getRecordOriginalHttpCodeInMetrics() {
        return this.recordOriginalHttpCodeInMetrics;
    }

    public void setRecordOriginalHttpCodeInMetrics(Boolean recordOriginalHttpCodeInMetrics) {
        this.recordOriginalHttpCodeInMetrics = recordOriginalHttpCodeInMetrics;
    }

    public boolean shouldIgnoreByHttpMethod(String httpMethod) {
        return !StringUtils.isNullOrEmpty(httpMethod) && this.ignoreHttpMethod.contains(httpMethod.toUpperCase());
    }

    public boolean shouldIgnore(String newSpanName) {
        if (StringUtils.isNullOrEmpty(newSpanName)) {
            return false;
        }
        boolean shouldIgnore = this.equalsUrlSet.contains(newSpanName);
        if (shouldIgnore) {
            return true;
        }
        if (!newSpanName.equals("/*")) {
            for (String suffix : this.endsWithUrlSet) {
                if (!newSpanName.endsWith(suffix)) continue;
                return true;
            }
            for (String pattern : this.matchUrlSet) {
                if (!this.matcher.match(pattern, newSpanName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldIgnoreByRpcName(String rpcName) {
        if (StringUtils.isNullOrEmpty(rpcName)) {
            return false;
        }
        return this.equalsRpcSet.contains(rpcName);
    }

    public String getIgnoreUrl() {
        return this.ignoreUrl;
    }

    public boolean isContainsMethodInSpanName() {
        return this.containsMethodInSpanName;
    }

    public void setContainsMethodInSpanName(boolean containsMethodInSpanName) {
        this.containsMethodInSpanName = containsMethodInSpanName;
    }

    public void setIgnoreUrl(String ignoreUrl) {
        this.ignoreUrl = ignoreUrl;
    }

    public void setIgnoreHttpMethod(String ignoreHttpMethod) {
        this.ignoreHttpMethod = ignoreHttpMethod;
    }
}

