/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.JsonMarshaler;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.ConfigKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.AdvancedExceptionFilter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.CollectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Endpoint(value=ConfigEnum.ARMS_APP_CONFIG_ENDPOINT)
@DataId(value=ConfigEnum.ARMS_APP_CONFIG_DATA_ID)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
@Namespace(value=ConfigEnum.ARMS_APP_CONFIG_NAMESPACE)
public class ArmsExceptionConfigState
extends ArmsState {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(ArmsExceptionConfigState.class.getName());
    private volatile Set<String> exceptionWhiteSet = new HashSet<String>();
    @ConfigKey(value="profiler.exception.whitelist", type=String.class)
    private volatile String exceptionWhiteList;
    @ConfigKey(value="profiler.exception.advancedWhitelist", type=String.class)
    private volatile String advancedExceptionWhiteList;
    @ConfigKey(value="profiler.exception.filterByParentClass")
    private volatile Boolean filterByParentClass = false;
    @ConfigKey(value="profiler.exception.fromConstructor.enable")
    private volatile boolean recordExceptionByConstructor = false;
    @ConfigKey(value="profiler.exception.fromInstrumentedMethod.enable")
    private volatile boolean recordExceptionByInstrumentedMethod = true;
    @ConfigKey(value="profiler.exception.stacktrace", type=Integer.class)
    private volatile int exceptionStacktrace = 2;
    private volatile List<AdvancedExceptionFilter> advancedExceptionFilterList = Collections.emptyList();
    public static ArmsExceptionConfigState exceptionConfigState = new ArmsExceptionConfigState();

    public ArmsExceptionConfigState() {
        super.registerConfigInstance(this);
    }

    @Override
    public void callback(String configInfo) {
        JsonMarshaler marshaler;
        logger.info("[ArmsExceptionConfigState] configInfo update.");
        this.exceptionWhiteSet = new HashSet<String>();
        if (!StringUtils.isEmpty(this.exceptionWhiteList)) {
            this.exceptionWhiteSet.addAll(Arrays.asList(this.exceptionWhiteList.split(",")));
        }
        if ((marshaler = GlobalInstanceHolder.getInstance(JsonMarshaler.class)) != null && !StringUtils.isEmpty(this.advancedExceptionWhiteList)) {
            this.advancedExceptionFilterList = marshaler.parseArray(this.advancedExceptionWhiteList, AdvancedExceptionFilter.class);
        }
    }

    private boolean isInWhiteList(String exceptionName) {
        for (String exception : this.exceptionWhiteSet) {
            if (!exceptionName.contains(exception)) continue;
            return true;
        }
        return false;
    }

    public void setFilterByParentClass(Boolean filterByParentClass) {
        this.filterByParentClass = filterByParentClass;
    }

    public Set<String> getExceptionWhiteSet() {
        return this.exceptionWhiteSet;
    }

    public void setExceptionWhiteSet(Set<String> exceptionWhiteSet) {
        this.exceptionWhiteSet = exceptionWhiteSet;
    }

    public boolean isInWhiteList(Throwable throwable) {
        return this.isInBaseWhiteList(throwable) || this.isInAdvancedWhiteList(throwable);
    }

    public boolean isInBaseWhiteList(Throwable throwable) {
        if (!this.filterByParentClass.booleanValue()) {
            return this.isInWhiteList(throwable.getClass().getName());
        }
        for (Class<?> currentClazz = throwable.getClass(); currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            if (!this.isInWhiteList(currentClazz.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isInAdvancedWhiteList(Throwable throwable) {
        if (CollectionUtils.isEmpty(this.advancedExceptionFilterList)) {
            return false;
        }
        for (AdvancedExceptionFilter filter : this.advancedExceptionFilterList) {
            if (!filter.match(throwable)) continue;
            return true;
        }
        return false;
    }

    public boolean isRecordExceptionByConstructor() {
        return this.recordExceptionByConstructor;
    }

    public boolean isRecordExceptionByInstrumentedMethod() {
        return this.recordExceptionByInstrumentedMethod;
    }

    public void setRecordExceptionByConstructor(boolean recordExceptionByConstructor) {
        this.recordExceptionByConstructor = recordExceptionByConstructor;
    }

    public int getExceptionStacktrace() {
        return this.exceptionStacktrace;
    }

    public void setAdvancedExceptionWhiteList(String advancedExceptionWhiteList) {
        this.advancedExceptionWhiteList = advancedExceptionWhiteList;
    }
}

