/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common;

import io.opentelemetry.javaagent.shaded.com.alibaba.arms.metrics.spec.UniCallKind;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.ArmsBusinessObservabilityMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.BusinessObservabilityService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsDataDegradationState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.MetricsRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsAttributesConvertUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ArmsCommonServiceMetrics
implements MetricsRecorder {
    protected static final long NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    protected final LongCounter totalRequestCount;
    protected final LongCounter errorRequestCount;
    protected final LongCounter slowRequestCount;
    protected final LongCounter statusRequestCount;
    protected final LongCounter requestDuration;
    protected final DoubleHistogram requestQuantileDuration;
    protected final LongHistogram responseSize;
    protected final LongHistogram requestSize;
    protected final DoubleHistogram delayDuration;
    protected final ArmsBusinessObservabilityMetrics bizMetrics;
    BusinessObservabilityService businessObservabilityService = GlobalInstanceHolder.getInstance(BusinessObservabilityService.class);

    public ArmsCommonServiceMetrics(Meter meter) {
        this.totalRequestCount = meter.counterBuilder("arms_rpc_requests_count").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.errorRequestCount = meter.counterBuilder("arms_rpc_requests_error_count").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.slowRequestCount = meter.counterBuilder("arms_rpc_requests_slow_count").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.statusRequestCount = meter.counterBuilder("arms_rpc_requests_by_status_count").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.requestDuration = meter.counterBuilder("arms_rpc_requests_seconds").setUnit("{ms}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.requestQuantileDuration = meter.histogramBuilder("arms_rpc_requests_latency_seconds").setUnit("{requests}").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.responseSize = meter.histogramBuilder("arms_rpc_result_bytes").setUnit("By").setDescription("Arms response bytes").ofLongs().build();
        this.requestSize = meter.histogramBuilder("arms_rpc_request_bytes").setUnit("By").setDescription("Arms request bytes").ofLongs().build();
        this.delayDuration = meter.histogramBuilder("arms_rpc_delay_seconds").setUnit("s").setDescription("The latency of rpc invocation").build();
        this.bizMetrics = new ArmsBusinessObservabilityMetrics(meter);
    }

    protected void recordNormalMetrics(Context context, long duration, Predicate<Long> isSlow, Attributes allAttributes) {
        this.recordNormalMetrics(context, duration, isSlow, allAttributes, 1L);
    }

    private void recordTotalRequestCount(long count, Attributes allAttributes, Context context) {
        this.totalRequestCount.add(count, allAttributes, context);
    }

    private void recordRequestDuration(long duration, Attributes allAttributes, Context context) {
        this.requestDuration.add(duration, allAttributes, context);
    }

    protected void recordNormalMetrics(Context context, long duration, Predicate<Long> isSlow, Attributes allAttributes, long count) {
        boolean slow;
        this.recordTotalRequestCount(count, allAttributes, context);
        this.recordRequestDuration(duration, allAttributes, context);
        boolean error = ArmsAttributesConvertUtil.hasError(context, allAttributes);
        if (error) {
            this.errorRequestCount.add(count, allAttributes);
            Span.fromContext(context).setStatus(StatusCode.ERROR);
        }
        if (slow = isSlow.test(duration)) {
            this.slowRequestCount.add(count, allAttributes);
        }
        if (this.businessObservabilityService != null && !this.businessObservabilityService.isBizO11yEnable()) {
            return;
        }
        if (this.bizMetrics != null) {
            ArmsBusinessObservabilityMetrics.MetricState metricState = new ArmsBusinessObservabilityMetrics.MetricState();
            metricState.recordTotal(count);
            metricState.recordDuration(duration);
            this.bizMetrics.onEnd(context, allAttributes, metricState);
            if (error) {
                metricState.recordError(count);
            }
            if (slow) {
                metricState.recordSlow(count);
            }
        }
    }

    protected void recordQuantileMetrics(String callKind, Attributes allAttributes, long duration) {
        if (!ArmsDataDegradationState.INSTANCE.isQuantileEnable()) {
            return;
        }
        String callType = allAttributes.get(ArmsConstants.AttributeKeys.ARMS_CALL_TYPE_KEY);
        Long rpcType = allAttributes.get(ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS);
        if (StringUtils.isEmpty(callType) || rpcType == null) {
            return;
        }
        if (callKind.equalsIgnoreCase(UniCallKind.HTTP.getName()) || callKind.equalsIgnoreCase(UniCallKind.RPC.getName()) || callKind.equalsIgnoreCase(UniCallKind.CONSUMER.getName()) || callKind.equalsIgnoreCase(UniCallKind.SCHEDULE.getName()) || callKind.equalsIgnoreCase(UniCallKind.SERVER.getName()) || callKind.equalsIgnoreCase(UniCallKind.CUSTOM_ENTRY.getName())) {
            this.recordInCallQuantileMetrics(callKind, callType, rpcType, allAttributes, duration);
        } else {
            this.recordOutCallQuantileMetrics(callKind, callType, rpcType, allAttributes, duration);
        }
    }

    protected void recordInCallQuantileMetrics(String callKind, String callType, Long rpcType, Attributes allAttributes, long duration) {
        if (!ArmsDataDegradationState.INSTANCE.isQuantileEnable() || !ArmsDataDegradationState.INSTANCE.isEnableQuantile4Interface()) {
            return;
        }
        String rpc = allAttributes.get(ArmsConstants.AttributeKeys.RPC);
        if (StringUtils.isEmpty(rpc)) {
            return;
        }
        Attributes quantileAttributes = Attributes.builder().put(ArmsConstants.AttributeKeys.ARMS_CALL_TYPE_KEY, callType).put(ArmsConstants.AttributeKeys.ARMS_CALL_KIND_KEY, callKind).put(ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS, rpcType).put(ArmsConstants.AttributeKeys.RPC, rpc).build();
        this.requestQuantileDuration.record(duration, quantileAttributes);
    }

    protected void recordOutCallQuantileMetrics(String callKind, String callType, Long rpcType, Attributes allAttributes, long duration) {
        if (!ArmsDataDegradationState.INSTANCE.isQuantileEnable()) {
            return;
        }
        if ((callKind.equalsIgnoreCase(UniCallKind.SQL.getName()) || callKind.equalsIgnoreCase(UniCallKind.DB.getName())) && !ArmsDataDegradationState.INSTANCE.isEnableQuantile4DB()) {
            return;
        }
        if ((callKind.equalsIgnoreCase(UniCallKind.NO_SQL.getName()) || callKind.equalsIgnoreCase(UniCallKind.CACHE.getName())) && !ArmsDataDegradationState.INSTANCE.isEnableQuantile4NOSQL()) {
            return;
        }
        if ((callKind.equalsIgnoreCase(UniCallKind.HTTP_CLIENT.getName()) || callKind.equalsIgnoreCase(UniCallKind.RPC_CLIENT.getName()) || callKind.equalsIgnoreCase(UniCallKind.CLIENT.getName())) && !ArmsDataDegradationState.INSTANCE.isEnableQuantile4Outcall()) {
            return;
        }
        if ((callKind.equalsIgnoreCase(UniCallKind.CONSUMER.getName()) || callKind.equalsIgnoreCase(UniCallKind.PRODUCER.getName())) && !ArmsDataDegradationState.INSTANCE.isEnableQuantile4MQ()) {
            return;
        }
        String endpoint = allAttributes.get(ArmsConstants.AttributeKeys.ENDPOINT_KEY);
        String distId = allAttributes.get(ArmsConstants.AttributeKeys.DEST_ID_KEY);
        if (StringUtils.isEmpty(endpoint) || StringUtils.isEmpty(distId)) {
            return;
        }
        Attributes quantileAttributes = Attributes.builder().put(ArmsConstants.AttributeKeys.ARMS_CALL_TYPE_KEY, callType).put(ArmsConstants.AttributeKeys.ARMS_CALL_KIND_KEY, callKind).put(ArmsConstants.AttributeKeys.RPC_TYPE_KEY_4_ARMS, rpcType).put(ArmsConstants.AttributeKeys.ENDPOINT_KEY, endpoint).put(ArmsConstants.AttributeKeys.DEST_ID_KEY, distId).build();
        this.requestQuantileDuration.record(duration, quantileAttributes);
    }
}

