/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.RpcIdGenerator;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AliyunContextHolderUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.RpcUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsRpcTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.tag.TagService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsBaggageIgnoreCaseState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common.ArmsExceptionConfigState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.exception.ArmsExceptionRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.exception.ArmsRecordExceptionResult;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class ArmsCommonAttributeExtractor
implements AttributesExtractor<Object, Object> {
    private static final PatchLogger logger = PatchLogger.getLogger(HttpCommonAttributesGetter.class.getName());
    private final int rpcType;
    private final int serviceType;
    private final String componentName;
    private final boolean isIncoming;
    private final ArmsRpcTypeEnum rpcTypeEnum;
    private final TagService tagService;
    private final ArmsExceptionRecorder exceptionRecordInstance;

    public ArmsCommonAttributeExtractor(int rpcType, int serviceType) {
        this.rpcType = rpcType;
        this.serviceType = serviceType;
        this.rpcTypeEnum = ArmsRpcTypeEnum.getByCode(rpcType);
        this.componentName = this.rpcTypeEnum.getName().toLowerCase();
        this.isIncoming = ArmsRpcTypeEnum.isIncomeRpcType(rpcType);
        this.tagService = GlobalInstanceHolder.getInstance(TagService.class);
        this.exceptionRecordInstance = GlobalInstanceHolder.getInstance(ArmsExceptionRecorder.class);
    }

    public ArmsCommonAttributeExtractor() {
        this(-1, -1);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, Object o) {
        if (this.rpcType >= 0 && this.serviceType >= 0) {
            attributes.put("component.name", this.componentName);
            attributes.put(ArmsConstants.AttributeKeys.RPC_TYPE, Long.valueOf(this.rpcType));
            attributes.put(ArmsConstants.AttributeKeys.RPC_TYPE_ENUM_INDEX_KEY, this.rpcTypeEnum.ordinal());
        }
        if (this.isIncoming) {
            this.handlePropagatorType(attributes, parentContext);
        }
        this.handleRootServiceAndSampleService(attributes, parentContext);
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, Object o, @Nullable Object o2, @Nullable Throwable error) {
        try {
            String rpc;
            StringBuffer exceptionIds;
            if (this.rpcType >= 0 && this.serviceType >= 0) {
                attributes.put(ArmsConstants.AttributeKeys.SERVICE_TYPE, this.serviceType);
                attributes.put(ArmsConstants.AttributeKeys.RPC_TYPE_KEY, Long.valueOf(this.rpcType));
                attributes.put(ArmsConstants.AttributeKeys.RPC_TYPE_ENUM_INDEX_KEY, this.rpcTypeEnum.ordinal());
                AttributesExtractorUtil.internalSet(attributes, ArmsConstants.AttributeKeys.RPC_TYPE, Long.valueOf(this.rpcType));
            }
            if (this.isIncoming) {
                this.handlePpid(attributes, context);
                this.handlePrpc(attributes, context);
            }
            String existedId = null;
            if (error != null && ArmsExceptionConfigState.exceptionConfigState.isRecordExceptionByInstrumentedMethod()) {
                if (!ArmsExceptionConfigState.exceptionConfigState.isInWhiteList(error)) {
                    if (this.exceptionRecordInstance != null) {
                        ArmsRecordExceptionResult exceptionResult = this.exceptionRecordInstance.recordException(error);
                        existedId = exceptionResult.getExcepTypeId();
                        attributes.put(ArmsConstants.AttributeKeys.SPAN_EXCEPTION_TYPE_ID_KEY, exceptionResult.getExcepTypeId());
                        attributes.put(ArmsConstants.AttributeKeys.SPAN_EXCEPTION_TYPE_OTHER_ID_KEY, exceptionResult.getExcepTypeId());
                        if (!StringUtils.isNullOrEmpty(exceptionResult.getExcepRawMsg())) {
                            attributes.put(ArmsConstants.AttributeKeys.SPAN_EXCEPTION_MESSAGE_KEY, exceptionResult.getExcepRawMsg());
                        } else {
                            attributes.put(ArmsConstants.AttributeKeys.SPAN_EXCEPTION_MESSAGE_KEY, exceptionResult.getExcepMsg());
                            attributes.put(ArmsConstants.AttributeKeys.SPAN_EXCEPTION_MESSAGE_ID_KEY, exceptionResult.getExcepMsgId());
                        }
                        attributes.put(ArmsConstants.AttributeKeys.EXCEPTION_TYPE_KEY, exceptionResult.getExcepTypeId());
                        attributes.put(ArmsConstants.AttributeKeys.EXCEPTION_INFO_KEY, "c4");
                    }
                    AliyunContextHolderUtils.putToAliyunContext("internal.exception.exited", true, context);
                }
                attributes.put(ArmsConstants.AttributeKeys.EXCEPTION_NAME_KEY, error.getClass().getSimpleName());
                attributes.put("exception.message", error.getMessage());
            }
            if (ArmsExceptionConfigState.exceptionConfigState.isRecordExceptionByConstructor() && (exceptionIds = context.get(ArmsConstants.ContextKeys.ALL_EXCEPTION_IDS_KEY)) != null && exceptionIds.length() > 0) {
                if (existedId == null) {
                    exceptionIds.deleteCharAt(exceptionIds.length() - 1);
                } else {
                    exceptionIds.append(existedId);
                }
                attributes.put(ArmsConstants.AttributeKeys.SPAN_EXCEPTION_TYPE_OTHER_ID_KEY, exceptionIds.toString());
            }
            if (!StringUtils.isNullOrEmpty(rpc = RpcUtils.getRpc(context))) {
                attributes.put(ArmsConstants.AttributeKeys.RPC, rpc);
            }
            if (this.needInjectTags()) {
                this.injectTagsToAttributes(this.tagService.getAppTagsMap(), attributes);
            }
            if (this.tagService != null) {
                this.tagService.extractTrafficTags(context, attributes);
            }
            RpcIdGenerator.addRpcIdIntoAttributeIfNeed(attributes, context);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to extract common attributes", t);
        }
    }

    private boolean needInjectTags() {
        if (this.tagService == null) {
            return false;
        }
        return !this.tagService.onlyInsertTags2IncomingSpan() || this.tagService.onlyInsertTags2IncomingSpan() && this.isIncoming;
    }

    private void injectTagsToAttributes(Map<String, String> tagsMap, AttributesBuilder attributesBuilder) {
        if (tagsMap == null) {
            return;
        }
        for (Map.Entry<String, String> entry : tagsMap.entrySet()) {
            attributesBuilder.put(entry.getKey(), entry.getValue());
        }
    }

    private void handlePrpc(AttributesBuilder attributes, Context context) {
        Baggage baggage = Baggage.fromContext(context);
        String pRpc = this.getEntryValue(baggage, "EagleEye-pRpc");
        if (!StringUtils.isNullOrEmpty(pRpc)) {
            attributes.put(ArmsConstants.AttributeKeys.PRPC_KEY, pRpc);
        }
    }

    private void handlePpid(AttributesBuilder attributes, Context context) {
        Baggage baggage = Baggage.fromContext(context);
        if (!StringUtils.isNullOrEmpty(this.getEntryValue(baggage, "EagleEye-pAppName"))) {
            attributes.put(ArmsConstants.AttributeKeys.PPID_KEY, Objects.requireNonNull(this.getEntryValue(baggage, "EagleEye-pAppName")));
        }
    }

    private void handlePropagatorType(AttributesBuilder attributes, Context context) {
        String propagatorType = context.get(ArmsConstants.ContextKeys.PROPAGATOR_TYPE);
        if (!StringUtils.isNullOrEmpty(propagatorType)) {
            attributes.put("trace.protocol.type", propagatorType);
        }
    }

    private void handleRootServiceAndSampleService(AttributesBuilder attributes, Context context) {
        Baggage baggage = Baggage.fromContext(context);
        String rootServiceId = this.getEntryValue(baggage, ArmsConstants.AttributeKeys.ROOT_SERVICE_KEY.getKey());
        String sampleServiceId = this.getEntryValue(baggage, ArmsConstants.AttributeKeys.SAMPLE_SERVICE_KEY.getKey());
        if (!StringUtils.isNullOrEmpty(rootServiceId)) {
            attributes.put(ArmsConstants.AttributeKeys.ROOT_SERVICE_KEY, rootServiceId);
        }
        if (!StringUtils.isNullOrEmpty(sampleServiceId)) {
            attributes.put(ArmsConstants.AttributeKeys.SAMPLE_SERVICE_KEY, sampleServiceId);
        } else {
            String sampleFlagIncomer = this.getEntryValue(baggage, ArmsConstants.AttributeKeys.SAMPLE_FLAG_INCOMER_KEY.getKey());
            if (!StringUtils.isNullOrEmpty(sampleFlagIncomer)) {
                attributes.put(ArmsConstants.AttributeKeys.SAMPLE_FLAG_INCOMER_KEY, sampleFlagIncomer);
            }
        }
    }

    private String getEntryValue(Baggage baggage, String key) {
        String value = baggage.getEntryValue(key);
        if (ArmsBaggageIgnoreCaseState.INSTANCE.isBaggageIgnoreCaseEnable() && StringUtils.isNullOrEmpty(value)) {
            value = baggage.getEntryValue(key.toLowerCase());
        }
        return value;
    }
}

