/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.arms.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import java.util.regex.Pattern;

class AdvancedExceptionFilter {
    private String exceptionName;
    private String messageStartsWith;
    private String messageEndsWith;
    private String messageContains;
    private String messagePattern;
    private Pattern pattern;

    AdvancedExceptionFilter() {
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public void setExceptionName(String exceptionName) {
        this.exceptionName = exceptionName;
    }

    public String getMessageStartsWith() {
        return this.messageStartsWith;
    }

    public void setMessageStartsWith(String messageStartsWith) {
        this.messageStartsWith = messageStartsWith;
    }

    public String getMessageEndsWith() {
        return this.messageEndsWith;
    }

    public void setMessageEndsWith(String messageEndsWith) {
        this.messageEndsWith = messageEndsWith;
    }

    public String getMessageContains() {
        return this.messageContains;
    }

    public void setMessageContains(String messageContains) {
        this.messageContains = messageContains;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
    }

    public boolean match(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (!throwable.getClass().getName().equals(this.exceptionName)) {
            return false;
        }
        String message = throwable.getMessage();
        if (message == null) {
            return false;
        }
        if (StringUtils.isNotEmpty(this.messageStartsWith) && message.startsWith(this.messageStartsWith)) {
            return true;
        }
        if (StringUtils.isNotEmpty(this.messageEndsWith) && message.endsWith(this.messageEndsWith)) {
            return true;
        }
        if (StringUtils.isNotEmpty(this.messageContains) && message.contains(this.messageContains)) {
            return true;
        }
        if (StringUtils.isNotEmpty(this.messagePattern)) {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(message);
            }
            return this.pattern.matcher(message).find();
        }
        return false;
    }
}

